/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.application.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationContext;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.application.rules.ContextCapture;
import java.util.List;

public class CalculationEvaluator<I, O, C extends CalculationContext<I, O>> {
    private final List<CalculationRule<I, O, C>> rules;

    public CalculationEvaluator(List<CalculationRule<I, O, C>> rules) {
        this.rules = rules;
    }

    public void evaluateRulesForContext(C calculationContext) {
        for (CalculationRule<I, O, C> rule : this.rules) {
            if (((CalculationContext)calculationContext).isCalculationCompleted()) break;
            if (!rule.shouldExecute(calculationContext)) continue;
            rule.calculate(calculationContext);
            ContextCapture.captureRule(calculationContext, rule.getClass());
        }
    }
}

