/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.fqhc.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import gov.cms.fiss.pricers.common.api.ReturnCodeData;
import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.application.rules.CalculationContext;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.fqhc.api.v2.FqhcClaimData;
import gov.cms.fiss.pricers.fqhc.api.v2.FqhcClaimPricingRequest;
import gov.cms.fiss.pricers.fqhc.api.v2.FqhcClaimPricingResponse;
import gov.cms.fiss.pricers.fqhc.api.v2.FqhcPaymentData;
import gov.cms.fiss.pricers.fqhc.api.v2.IoceServiceLineData;
import gov.cms.fiss.pricers.fqhc.api.v2.ServiceLinePaymentData;
import gov.cms.fiss.pricers.fqhc.core.ReturnCode;
import gov.cms.fiss.pricers.fqhc.core.daily.DaySummary;
import gov.cms.fiss.pricers.fqhc.core.tables.DataTables;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class FqhcPricerContext
extends CalculationContext<FqhcClaimPricingRequest, FqhcClaimPricingResponse> {
    public static final String CALCULATION_VERSION = "2025.2";
    private static final LocalDate GFTF_START_DATE = DateTimeFormatter.BASIC_ISO_DATE.parse((CharSequence)"20160101", LocalDate::from);
    private static final LocalDate FQHC_START_DATE = DateTimeFormatter.BASIC_ISO_DATE.parse((CharSequence)"20141001", LocalDate::from);
    private static final LocalDate IOP_START_DATE = LocalDate.of(2024, 1, 1);
    private static final LocalDate IOP_SPLIT_START_DATE = LocalDate.of(2025, 1, 1);
    static final BigDecimal COINSURANCE_RATE = BigDecimal.valueOf(0.2);
    @JsonIgnore
    private final Map<Integer, DataTables> dataTables;
    @JsonProperty
    private final SortedMap<LocalDate, DaySummary> daySummaries = new TreeMap<LocalDate, DaySummary>();
    private boolean gftfClaim = false;
    private boolean maClaim = false;

    public FqhcPricerContext(FqhcClaimPricingRequest input, FqhcClaimPricingResponse output, Map<Integer, DataTables> dataTables) {
        super(input, output);
        this.dataTables = dataTables;
        this.initializeContext();
    }

    private void initializeContext() {
        ((FqhcClaimPricingResponse)this.getOutput()).setCalculationVersion(CALCULATION_VERSION);
        ((FqhcClaimPricingResponse)this.getOutput()).setPaymentData(new FqhcPaymentData());
        ((FqhcClaimPricingResponse)this.getOutput()).setReturnCodeData(new ReturnCodeData());
        this.getPaymentData().setTotalPayment(BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP));
        this.getPaymentData().setServiceLinePayments(this.getIoceServiceLines().stream().map(ioceServiceLine -> {
            ServiceLinePaymentData serviceLinePayment = new ServiceLinePaymentData();
            serviceLinePayment.setLineNumber(ioceServiceLine.getLineNumber());
            ReturnCodeData returnCodeData = new ReturnCodeData();
            returnCodeData.setCode("00");
            returnCodeData.setDescription("No description available");
            serviceLinePayment.setReturnCodeData(returnCodeData);
            return serviceLinePayment;
        }).collect(Collectors.toList()));
    }

    @JsonIgnore
    public List<IoceServiceLineData> getIoceServiceLines() {
        return this.getClaimData().getIoceServiceLines();
    }

    public ServiceLinePaymentData getServiceLinePayments(int lineNumber) {
        return this.getPaymentData().getServiceLinePayments().stream().filter(serviceLinePayment -> serviceLinePayment.getLineNumber() == lineNumber).findFirst().orElseThrow();
    }

    @JsonIgnore
    public List<ServiceLinePaymentData> getServiceLinePayments() {
        return this.getPaymentData().getServiceLinePayments();
    }

    @JsonIgnore
    public FqhcClaimData getClaimData() {
        return (FqhcClaimData)((FqhcClaimPricingRequest)this.getInput()).getClaimData();
    }

    @JsonIgnore
    public FqhcPaymentData getPaymentData() {
        return (FqhcPaymentData)((FqhcClaimPricingResponse)this.getOutput()).getPaymentData();
    }

    public void applyClaimReturnCode(ReturnCode returnCode) {
        ((FqhcClaimPricingResponse)this.getOutput()).getReturnCodeData().setCode(returnCode.getCode());
        ((FqhcClaimPricingResponse)this.getOutput()).getReturnCodeData().setDescription(returnCode.getDescription());
        if (!StringUtils.isBlank(returnCode.getExplanation())) {
            ((FqhcClaimPricingResponse)this.getOutput()).getReturnCodeData().setExplanation(returnCode.getExplanation());
        } else {
            ((FqhcClaimPricingResponse)this.getOutput()).getReturnCodeData().setExplanation(null);
        }
    }

    public DataTables getDataTables(LocalDate serviceDate) {
        return this.dataTables.getOrDefault(serviceDate.getYear(), new DataTables(new TreeMap<LocalDate, BigDecimal>(), new TreeMap<LocalDate, BigDecimal>(), new TreeMap<LocalDate, BigDecimal>(), new TreeMap<LocalDate, BigDecimal>(), new HashMap<String, NavigableMap<LocalDate, BigDecimal>>(), new TreeMap<LocalDate, BigDecimal>()));
    }

    public String getReturnCode() {
        return ((FqhcClaimPricingResponse)this.getOutput()).getReturnCodeData().getCode();
    }

    public void setGftfClaim() {
        this.gftfClaim = true;
    }

    public void setMaClaim() {
        this.maClaim = true;
    }

    public DaySummary getLastDaySummary() {
        if (this.daySummaries.isEmpty()) {
            return null;
        }
        return (DaySummary)this.daySummaries.get(this.daySummaries.lastKey());
    }

    public @FixedValue DaySummary getDaySummary(LocalDate serviceDate) {
        return (DaySummary)this.daySummaries.get(serviceDate);
    }

    public void applyDaySummary(LocalDate serviceDate, DaySummary daySummary) {
        this.daySummaries.putIfAbsent(serviceDate, daySummary);
    }

    public @FixedValue BigDecimal getCoinsuranceRate() {
        return COINSURANCE_RATE;
    }

    public LocalDate getFqhcStartDate() {
        return FQHC_START_DATE;
    }

    public LocalDate getIopStartDate() {
        return IOP_START_DATE;
    }

    public LocalDate getIopSplitStartDate() {
        return IOP_SPLIT_START_DATE;
    }

    public LocalDate getGftfStartDate() {
        return GFTF_START_DATE;
    }

    public boolean isValidMdpcpReductionPercentage() {
        BigDecimal mdpcpPercentage = this.getClaimData().getMdpcpReductionPercent();
        return BigDecimalUtils.equals(mdpcpPercentage, new BigDecimal(".10")) || BigDecimalUtils.equals(mdpcpPercentage, new BigDecimal(".25")) || BigDecimalUtils.equals(mdpcpPercentage, new BigDecimal(".40")) || BigDecimalUtils.equals(mdpcpPercentage, new BigDecimal(".65"));
    }

    public boolean containsMdpcpDemoCode() {
        return this.getClaimData().getDemoCodes() != null && this.getClaimData().getDemoCodes().contains("83");
    }

    @Generated
    public boolean isGftfClaim() {
        return this.gftfClaim;
    }

    @Generated
    public boolean isMaClaim() {
        return this.maClaim;
    }
}

