/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.fqhc.core.rules.processing;

import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.fqhc.api.v2.IoceServiceLineData;
import gov.cms.fiss.pricers.fqhc.api.v2.ServiceLinePaymentData;
import gov.cms.fiss.pricers.fqhc.core.FqhcPricerContext;
import gov.cms.fiss.pricers.fqhc.core.ReturnCode;
import gov.cms.fiss.pricers.fqhc.core.ServiceLineContext;
import gov.cms.fiss.pricers.fqhc.core.daily.DaySummary;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class CalculateCoinsurancePayment
implements CalculationRule<IoceServiceLineData, ServiceLinePaymentData, ServiceLineContext> {
    @Override
    public void calculate(ServiceLineContext calculationContext) {
        IoceServiceLineData ioceServiceLine = (IoceServiceLineData)calculationContext.getInput();
        ServiceLinePaymentData serviceLinePayment = (ServiceLinePaymentData)calculationContext.getOutput();
        DaySummary daySummary = calculationContext.getDaySummary();
        FqhcPricerContext fqhcPricerContext = calculationContext.getFqhcPricerContext();
        if (fqhcPricerContext.isMaClaim() && StringUtils.equals(ioceServiceLine.getRevenueCode(), "0519") || StringUtils.equals(ioceServiceLine.getPaymentIndicator(), "16")) {
            serviceLinePayment.setCoinsuranceAmount(BigDecimalUtils.ZERO);
            return;
        }
        if (!daySummary.isCoinsuranceNotApplicablePackageLinePresent()) {
            this.calculateAndSetStandardCoinsurance(calculationContext, fqhcPricerContext.getCoinsuranceRate());
        } else if (!daySummary.isOtherPackageLinePresent() && daySummary.isCoinsuranceNotApplicablePackageLinePresent()) {
            serviceLinePayment.setCoinsuranceAmount(BigDecimalUtils.ZERO);
            this.adjustReturnCodeForPreventiveCare(serviceLinePayment, daySummary);
        } else {
            this.updatePaymentCoinsuranceNotApplicable(calculationContext, daySummary, fqhcPricerContext.getCoinsuranceRate());
        }
        if (calculationContext.isCoinsuranceNAPaymentFlag()) {
            serviceLinePayment.setCoinsuranceAmount(BigDecimalUtils.ZERO);
        }
    }

    private void calculateAndSetStandardCoinsurance(ServiceLineContext calculationContext, @FixedValue BigDecimal coinsuranceRate) {
        ((ServiceLinePaymentData)calculationContext.getOutput()).setCoinsuranceAmount(calculationContext.getUnreducedPayment().multiply(coinsuranceRate).setScale(2, RoundingMode.HALF_UP));
    }

    private void updatePaymentCoinsuranceNotApplicable(ServiceLineContext calculationContext, DaySummary daySummary, BigDecimal coinsuranceRate) {
        IoceServiceLineData ioceServiceLine = (IoceServiceLineData)calculationContext.getInput();
        ServiceLinePaymentData serviceLinePayment = (ServiceLinePaymentData)calculationContext.getOutput();
        if (StringUtils.equals(ioceServiceLine.getCompositeAdjustmentFlag(), "02") && daySummary.isMedicalPaidLinePresent() || StringUtils.equals(ioceServiceLine.getCompositeAdjustmentFlag(), "03") && (daySummary.isMedicalPaidLinePresent() || daySummary.isMentalPaidLinePresent()) || StringUtils.equalsAny(ioceServiceLine.getCompositeAdjustmentFlag(), "04", "05") && (daySummary.isMedicalPaidLinePresent() || daySummary.isMod59PaidLinePresent())) {
            this.calculateAndSetStandardCoinsurance(calculationContext, coinsuranceRate);
        } else {
            if (BigDecimalUtils.isGreaterThan(serviceLinePayment.getPayment(), daySummary.getTotalCoinsuranceNotApplicablePackageCharges())) {
                BigDecimal baseCoin = serviceLinePayment.getPayment().subtract(daySummary.getTotalCoinsuranceNotApplicablePackageCharges()).setScale(2, RoundingMode.HALF_UP);
                serviceLinePayment.setCoinsuranceAmount(baseCoin.multiply(coinsuranceRate).setScale(2, RoundingMode.HALF_UP));
            } else {
                serviceLinePayment.setCoinsuranceAmount(BigDecimalUtils.ZERO);
            }
            this.adjustReturnCodeForPreventiveCare(serviceLinePayment, daySummary);
        }
    }

    protected void adjustReturnCodeForPreventiveCare(ServiceLinePaymentData serviceLinePayment, DaySummary daySummary) {
        if (daySummary.isPreventivePresent() && List.of("01", "05").contains(serviceLinePayment.getReturnCodeData().getCode())) {
            serviceLinePayment.setReturnCodeData(ReturnCode.LINE_PAY_BASED_ON_PPS_RATE_PS_PRES_03.toReturnCodeData());
        }
        if (daySummary.isPreventivePresent() && StringUtils.equals(serviceLinePayment.getReturnCodeData().getCode(), "02")) {
            serviceLinePayment.setReturnCodeData(ReturnCode.LINE_PAY_BASED_ON_PROV_SUB_CHRGS_PS_PRES_04.toReturnCodeData());
        }
    }
}

