/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.fqhc.core.rules.processing;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.fqhc.api.v2.IoceServiceLineData;
import gov.cms.fiss.pricers.fqhc.api.v2.ServiceLinePaymentData;
import gov.cms.fiss.pricers.fqhc.core.FqhcPricerContext;
import gov.cms.fiss.pricers.fqhc.core.ServiceLineContext;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang3.StringUtils;

public class CalculateMdpcpReductionAmount
implements CalculationRule<IoceServiceLineData, ServiceLinePaymentData, ServiceLineContext> {
    @Override
    public boolean shouldExecute(ServiceLineContext serviceLineContext) {
        FqhcPricerContext calculationContext = serviceLineContext.getFqhcPricerContext();
        return calculationContext.containsMdpcpDemoCode() && StringUtils.equalsAny(((IoceServiceLineData)serviceLineContext.getInput()).getHcpcsCode(), "G0466", "G0467", "G0468") && serviceLineContext.isValidRevenueCode() && calculationContext.isValidMdpcpReductionPercentage();
    }

    @Override
    public void calculate(ServiceLineContext serviceLineContext) {
        ServiceLinePaymentData serviceLinePayment = (ServiceLinePaymentData)serviceLineContext.getOutput();
        BigDecimal coInsurancePayment = serviceLinePayment.getCoinsuranceAmount();
        BigDecimal lineItemReimbursement = serviceLinePayment.getPayment().subtract(coInsurancePayment);
        FqhcPricerContext calculationContext = serviceLineContext.getFqhcPricerContext();
        BigDecimal mdpcpReductionAmount = calculationContext.getClaimData().getMdpcpReductionPercent().multiply(lineItemReimbursement).setScale(2, RoundingMode.HALF_UP);
        lineItemReimbursement = lineItemReimbursement.subtract(mdpcpReductionAmount).setScale(2, RoundingMode.HALF_UP);
        BigDecimal lineItemPayment = coInsurancePayment.add(lineItemReimbursement).setScale(2, RoundingMode.HALF_UP);
        serviceLinePayment.setMdpcpReductionAmount(mdpcpReductionAmount);
        serviceLinePayment.setPayment(lineItemPayment);
    }
}

