// Generated by delombok at Tue May 20 17:40:33 UTC 2025
package gov.cms.fiss.pricers.fqhc;

import static java.util.Map.entry;
import gov.cms.fiss.pricers.common.application.OpenApiPricerApplication;
import gov.cms.fiss.pricers.common.application.contract.OpenApiCustomizer;
import gov.cms.fiss.pricers.fqhc.core.FqhcPricerContext;
import gov.cms.fiss.pricers.fqhc.core.FqhcPricerDispatch;
import gov.cms.fiss.pricers.fqhc.resources.FqhcClaimPricingResource;
import io.dropwizard.setup.Environment;
import io.swagger.v3.oas.models.info.Info;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class FqhcPricerApplication extends OpenApiPricerApplication<FqhcPricerConfiguration> {
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  private static final org.slf4j.Logger LOGGER = org.slf4j.LoggerFactory.getLogger(FqhcPricerApplication.class);

  public static void main(String[] args) throws Exception {
    new FqhcPricerApplication().run(args);
  }

  @Override
  protected void configureApplication(FqhcPricerConfiguration configuration, Environment environment) {
    final FqhcClaimPricingResource v2Resource = new FqhcClaimPricingResource(new FqhcPricerDispatch(configuration));
    environment.jersey().register(v2Resource);
  }

  @Override
  protected List<OpenApiCustomizer> getContractCustomizers() {
    final List<OpenApiCustomizer> customizers = new ArrayList<>(super.getContractCustomizers());
    customizers.add((configuration, environment, oas) -> oas.info(new Info().title("FQHC Pricer").version("v1")));
    return customizers;
  }

  @Override
  public String getName() {
    return "fqhc-pricer";
  }

  @Override
  protected List<Package> getResourcePackages() {
    return Collections.singletonList(FqhcClaimPricingResource.class.getPackage());
  }

  // Remove the oldest year, to add new year to list. List only can include total of 10
  // Calculation Version Years
  @Override
  protected Map<Integer, String> getCalculationVersions() {
    return Map.ofEntries(entry(2025, FqhcPricerContext.CALCULATION_VERSION), entry(2024, FqhcPricerContext.CALCULATION_VERSION), entry(2023, FqhcPricerContext.CALCULATION_VERSION), entry(2022, FqhcPricerContext.CALCULATION_VERSION), entry(2021, FqhcPricerContext.CALCULATION_VERSION), entry(2020, FqhcPricerContext.CALCULATION_VERSION), entry(2019, FqhcPricerContext.CALCULATION_VERSION), entry(2018, FqhcPricerContext.CALCULATION_VERSION), entry(2017, FqhcPricerContext.CALCULATION_VERSION), entry(2016, FqhcPricerContext.CALCULATION_VERSION), entry(2015, FqhcPricerContext.CALCULATION_VERSION));
  }
}
