// Generated by delombok at Tue May 20 17:40:33 UTC 2025
package gov.cms.fiss.pricers.fqhc.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import gov.cms.fiss.pricers.common.api.ReturnCodeData;
import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.application.rules.CalculationContext;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.fqhc.api.v2.FqhcClaimData;
import gov.cms.fiss.pricers.fqhc.api.v2.FqhcClaimPricingRequest;
import gov.cms.fiss.pricers.fqhc.api.v2.FqhcClaimPricingResponse;
import gov.cms.fiss.pricers.fqhc.api.v2.FqhcPaymentData;
import gov.cms.fiss.pricers.fqhc.api.v2.IoceServiceLineData;
import gov.cms.fiss.pricers.fqhc.api.v2.ServiceLinePaymentData;
import gov.cms.fiss.pricers.fqhc.core.daily.DaySummary;
import gov.cms.fiss.pricers.fqhc.core.tables.DataTables;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class FqhcPricerContext extends CalculationContext<FqhcClaimPricingRequest, FqhcClaimPricingResponse> {
  public static final String CALCULATION_VERSION = "2025.2";
  // Constants for use in calculations and logic
  private static final LocalDate GFTF_START_DATE = DateTimeFormatter.BASIC_ISO_DATE.parse("20160101", LocalDate::from);
  private static final LocalDate FQHC_START_DATE = DateTimeFormatter.BASIC_ISO_DATE.parse("20141001", LocalDate::from);
  // IOP effective date 01/01/2024
  private static final LocalDate IOP_START_DATE = LocalDate.of(2024, 1, 1);
  private static final LocalDate IOP_SPLIT_START_DATE = LocalDate.of(2025, 1, 1);
  static final BigDecimal COINSURANCE_RATE = BigDecimal.valueOf(0.2);
  // Lookup content
  @JsonIgnore
  private final Map<Integer, DataTables> dataTables;
  // State variables
  @JsonProperty
  private final SortedMap<LocalDate, DaySummary> daySummaries = new TreeMap<>();
  private boolean gftfClaim = false;
  private boolean maClaim = false;

  public FqhcPricerContext(FqhcClaimPricingRequest input, FqhcClaimPricingResponse output, Map<Integer, DataTables> dataTables) {
    super(input, output);
    this.dataTables = dataTables;
    initializeContext();
  }

  private void initializeContext() {
    getOutput().setCalculationVersion(CALCULATION_VERSION);
    getOutput().setPaymentData(new FqhcPaymentData());
    getOutput().setReturnCodeData(new ReturnCodeData());
    getPaymentData().setTotalPayment(BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP));
    // Creates matching output lines, initialized with line numbers that match the input lines
    getPaymentData().setServiceLinePayments(getIoceServiceLines().stream().map(ioceServiceLine -> {
      final ServiceLinePaymentData serviceLinePayment = new ServiceLinePaymentData();
      serviceLinePayment.setLineNumber(ioceServiceLine.getLineNumber());
      final ReturnCodeData returnCodeData = new ReturnCodeData();
      returnCodeData.setCode("00");
      returnCodeData.setDescription("No description available");
      serviceLinePayment.setReturnCodeData(returnCodeData);
      return serviceLinePayment;
    }).collect(Collectors.toList()));
  }

  // Access to request/response content
  @JsonIgnore
  public List<IoceServiceLineData> getIoceServiceLines() {
    return getClaimData().getIoceServiceLines();
  }

  /**
   * Retrieves the output line that matches the current input line.
   *
   * @param lineNumber the number of the input line
   * @return the matching output line
   * @throws java.util.NoSuchElementException if no output exists for the specified input; this
   *     should never happen unless there is a bug
   */
  public ServiceLinePaymentData getServiceLinePayments(int lineNumber) {
    return getPaymentData().getServiceLinePayments().stream().filter(serviceLinePayment -> serviceLinePayment.getLineNumber() == lineNumber).findFirst().orElseThrow();
  }

  @JsonIgnore
  public List<ServiceLinePaymentData> getServiceLinePayments() {
    return getPaymentData().getServiceLinePayments();
  }

  @JsonIgnore
  public FqhcClaimData getClaimData() {
    return getInput().getClaimData();
  }

  @JsonIgnore
  public FqhcPaymentData getPaymentData() {
    return getOutput().getPaymentData();
  }

  // Calculation data
  public void applyClaimReturnCode(final ReturnCode returnCode) {
    getOutput().getReturnCodeData().setCode(returnCode.getCode());
    getOutput().getReturnCodeData().setDescription(returnCode.getDescription());
    if (!StringUtils.isBlank(returnCode.getExplanation())) {
      getOutput().getReturnCodeData().setExplanation(returnCode.getExplanation());
    } else {
      getOutput().getReturnCodeData().setExplanation(null);
    }
  }

  public DataTables getDataTables(LocalDate serviceDate) {
    return dataTables.getOrDefault(serviceDate.getYear(), new DataTables(new TreeMap<>(), new TreeMap<>(), new TreeMap<>(), new TreeMap<>(), new HashMap<>(), new TreeMap<>()));
  }

  public String getReturnCode() {
    return getOutput().getReturnCodeData().getCode();
  }

  // Manage state
  public void setGftfClaim() {
    gftfClaim = true;
  }

  public void setMaClaim() {
    maClaim = true;
  }

  public DaySummary getLastDaySummary() {
    if (daySummaries.isEmpty()) {
      return null;
    }
    return daySummaries.get(daySummaries.lastKey());
  }

  @FixedValue
  public DaySummary getDaySummary(LocalDate serviceDate) {
    return daySummaries.get(serviceDate);
  }

  public void applyDaySummary(LocalDate serviceDate, DaySummary daySummary) {
    daySummaries.putIfAbsent(serviceDate, daySummary);
  }

  // Per-year value retrieval
  @FixedValue
  public BigDecimal getCoinsuranceRate() {
    return COINSURANCE_RATE;
  }

  public LocalDate getFqhcStartDate() {
    return FQHC_START_DATE;
  }

  public LocalDate getIopStartDate() {
    return IOP_START_DATE;
  }

  public LocalDate getIopSplitStartDate() {
    return IOP_SPLIT_START_DATE;
  }

  public LocalDate getGftfStartDate() {
    return GFTF_START_DATE;
  }

  // 09/10/2021 MDPCP - CLG
  public boolean isValidMdpcpReductionPercentage() {
    final BigDecimal mdpcpPercentage = getClaimData().getMdpcpReductionPercent();
    return BigDecimalUtils.equals(mdpcpPercentage, new BigDecimal(".10")) || BigDecimalUtils.equals(mdpcpPercentage, new BigDecimal(".25")) || BigDecimalUtils.equals(mdpcpPercentage, new BigDecimal(".40")) || BigDecimalUtils.equals(mdpcpPercentage, new BigDecimal(".65"));
  }

  public boolean containsMdpcpDemoCode() {
    return getClaimData().getDemoCodes() != null && getClaimData().getDemoCodes().contains("83");
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isGftfClaim() {
    return this.gftfClaim;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isMaClaim() {
    return this.maClaim;
  }
}
