/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.application.errors;

import gov.cms.fiss.pricers.common.application.errors.BaseError;
import gov.cms.fiss.pricers.common.application.request.RequestContentExtractor;
import java.util.Objects;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.problem.Problem;
import org.zalando.problem.ProblemBuilder;
import org.zalando.problem.Status;

@Provider
public abstract class AbstractStatusExceptionMapper<E extends Throwable>
implements ExceptionMapper<E> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractStatusExceptionMapper.class);
    protected final Response.Status status;
    protected final String title;

    protected AbstractStatusExceptionMapper() {
        this(null, null);
    }

    protected AbstractStatusExceptionMapper(Response.Status status, String title) {
        this.status = status;
        this.title = title;
    }

    @Override
    public Response toResponse(E exception) {
        BaseError error = this.generateError(exception);
        this.handleLogging(exception, error);
        if (null == RequestContentExtractor.rfc7807Support()) {
            return Response.status(error.getCode()).type("application/json").entity(error).build();
        }
        Problem problem = this.generateProblem(exception);
        return Response.status(Objects.requireNonNull(problem.getStatus()).getStatusCode()).type("application/problem+json").entity(problem).build();
    }

    protected abstract BaseError generateError(E var1);

    protected abstract Problem generateProblem(E var1);

    protected Problem generateProblem(E exception, String title, Response.Status status) {
        ProblemBuilder problemBuilder = Problem.builder().withTitle(title).withStatus(Status.valueOf(status.getStatusCode())).withDetail(((Throwable)exception).getMessage());
        return problemBuilder.build();
    }

    protected void handleLogging(E exception, BaseError error) {
        LOGGER.debug("Failed with exception `{}` and errors: {}", (Object)((Throwable)exception).getMessage(), (Object)error.getErrors());
    }
}

