/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.application.filters;

import ch.qos.logback.classic.Logger;
import com.fasterxml.jackson.databind.ObjectMapper;
import gov.cms.fiss.pricers.common.application.filters.ContentLengthFilterConfiguration;
import gov.cms.fiss.pricers.common.application.filters.LogContent;
import gov.cms.fiss.pricers.common.application.filters.LogFilterConfiguration;
import gov.cms.fiss.pricers.common.application.filters.PricerContentLogFilter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Priority;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@Priority(value=5000)
@Provider
public class PricerRequestLogFilter
extends PricerContentLogFilter
implements ContainerRequestFilter {
    private static final Logger LOGGER = (Logger)LoggerFactory.getLogger(PricerRequestLogFilter.class);
    private static final Pattern REQUEST_ID_PATTERN = Pattern.compile("\"requestId\"\\s*:\\s*(\\d+)");
    private static final Pattern REQUEST_IDENTIFIER_PATTERN = Pattern.compile("\"requestIdentifier\"\\s*:\\s*\"([-\\w]+)\"");
    private static final Pattern REQUEST_WHITESPACE_REMOVAL_PATTERN = Pattern.compile("(\"[^\"]*\")|\\s");
    private final ContentLengthFilterConfiguration contentLengthFilterConfiguration;

    public PricerRequestLogFilter(ObjectMapper mapper, LogFilterConfiguration logFilterConfiguration, ContentLengthFilterConfiguration contentLengthFilterConfiguration) {
        super(LOGGER, mapper, logFilterConfiguration);
        this.contentLengthFilterConfiguration = contentLengthFilterConfiguration;
    }

    @Override
    public void filter(ContainerRequestContext requestContext) throws IOException {
        String requestId;
        String dcn;
        MDC.put("startTime", String.valueOf(System.currentTimeMillis()));
        MDC.put("transactionID", UUID.randomUUID().toString());
        MDC.put("method", requestContext.getMethod());
        String uriPath = requestContext.getUriInfo().getAbsolutePath().getPath();
        MDC.put("uri", StringUtils.removeEnd(uriPath, "/"));
        String userAgent = requestContext.getHeaderString("User-Agent");
        if (userAgent != null) {
            MDC.put("userAgent", userAgent);
        }
        if ((dcn = requestContext.getHeaderString("cms-dcn")) != null) {
            MDC.put("documentControlNumber", dcn);
        }
        if ((requestId = requestContext.getHeaderString("cms-pricer-request-id")) != null) {
            MDC.put("requestIdentifier", requestId);
        }
        String headerJSON = this.mapper.writeValueAsString(this.constrainStringMap(requestContext.getHeaders()));
        String requestBody = this.readRequestEntityStream(requestContext);
        LogContent logContent = new LogContent("Request started");
        logContent.setHeaders(headerJSON);
        String queryJson = this.mapper.writeValueAsString(this.constrainStringMap(requestContext.getUriInfo().getQueryParameters()));
        logContent.setQueryParameters(queryJson);
        if (!requestBody.isEmpty() && !StringUtils.contains((CharSequence)uriPath, "openapi.")) {
            this.extractRequestId(requestBody);
            logContent.setRequestBody(requestBody);
        }
        String convertedLogContent = this.mapper.writeValueAsString(logContent);
        LOGGER.info("{}", (Object)convertedLogContent);
    }

    private void extractRequestId(String requestBody) {
        Matcher matcherIdentity;
        Matcher matcherId = REQUEST_ID_PATTERN.matcher(requestBody);
        if (matcherId.find()) {
            MDC.put("requestID", matcherId.group(1));
        }
        if (null == MDC.get("requestIdentifier") && (matcherIdentity = REQUEST_IDENTIFIER_PATTERN.matcher(requestBody)).find()) {
            MDC.put("requestIdentifier", matcherIdentity.group(1));
        }
    }

    private String readRequestEntityStream(ContainerRequestContext requestContext) {
        InputStream inputStream = requestContext.getEntityStream();
        StringBuilder builder = new StringBuilder();
        try {
            byte[] requestEntity;
            if (this.contentLengthFilterConfiguration.isEnabled()) {
                requestEntity = inputStream.readNBytes(this.contentLengthFilterConfiguration.getMaximumRequestSize());
                if (-1 != inputStream.read()) {
                    LOGGER.info("Request too large: over {} bytes", (Object)this.contentLengthFilterConfiguration.getMaximumRequestSize());
                    throw new ClientErrorException(Response.Status.REQUEST_ENTITY_TOO_LARGE);
                }
            } else {
                requestEntity = inputStream.readAllBytes();
            }
            if (requestEntity.length != 0) {
                builder.append(new String(requestEntity, StandardCharsets.UTF_8));
            }
            requestContext.setEntityStream(new ByteArrayInputStream(requestEntity));
        }
        catch (IOException ex) {
            LOGGER.error("Unable to read request entity stream: {}", (Object)ex.getMessage());
            return "";
        }
        Matcher matcher = REQUEST_WHITESPACE_REMOVAL_PATTERN.matcher(builder.toString());
        return matcher.replaceAll("$1");
    }
}

