/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.fqhc.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.application.rules.EvaluatingCalculationRule;
import gov.cms.fiss.pricers.fqhc.api.v2.FqhcClaimPricingRequest;
import gov.cms.fiss.pricers.fqhc.api.v2.FqhcClaimPricingResponse;
import gov.cms.fiss.pricers.fqhc.api.v2.IoceServiceLineData;
import gov.cms.fiss.pricers.fqhc.api.v2.ServiceLinePaymentData;
import gov.cms.fiss.pricers.fqhc.core.FqhcPricerContext;
import gov.cms.fiss.pricers.fqhc.core.ServiceLineContext;
import java.util.List;

public class DefaultLineValidation
implements CalculationRule<FqhcClaimPricingRequest, FqhcClaimPricingResponse, FqhcPricerContext> {
    private final EvaluatingCalculationRule<IoceServiceLineData, ServiceLinePaymentData, ServiceLineContext> evaluationRule;

    public DefaultLineValidation(List<CalculationRule<IoceServiceLineData, ServiceLinePaymentData, ServiceLineContext>> calculationRules) {
        this.evaluationRule = new EvaluatingCalculationRule(calculationRules);
    }

    @Override
    public void calculate(FqhcPricerContext calculationContext) {
        for (IoceServiceLineData lineInput : calculationContext.getIoceServiceLines()) {
            ServiceLinePaymentData serviceLinePayment = calculationContext.getServiceLinePayments(lineInput.getLineNumber());
            this.evaluationRule.calculate(new ServiceLineContext(lineInput, serviceLinePayment, calculationContext));
        }
    }
}

