/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.fqhc.core.rules.processing;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.common.util.LocalDateUtils;
import gov.cms.fiss.pricers.fqhc.api.v2.IoceServiceLineData;
import gov.cms.fiss.pricers.fqhc.api.v2.ServiceLinePaymentData;
import gov.cms.fiss.pricers.fqhc.core.FqhcPricerContext;
import gov.cms.fiss.pricers.fqhc.core.ServiceLineContext;
import gov.cms.fiss.pricers.fqhc.core.daily.DaySummary;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;

public class CalculateNonMAClaimLinePayment
implements CalculationRule<IoceServiceLineData, ServiceLinePaymentData, ServiceLineContext> {
    @Override
    public void calculate(ServiceLineContext calculationContext) {
        IoceServiceLineData ioceServiceLine = (IoceServiceLineData)calculationContext.getInput();
        ServiceLinePaymentData serviceLinePayment = (ServiceLinePaymentData)calculationContext.getOutput();
        DaySummary daySummary = calculationContext.getDaySummary();
        BigDecimal ppsRate = calculationContext.getPpsRate();
        FqhcPricerContext fqhcPricerContext = calculationContext.getFqhcPricerContext();
        BigDecimal payment = BigDecimalUtils.ZERO;
        if (StringUtils.equals("01", ioceServiceLine.getCompositeAdjustmentFlag())) {
            payment = BigDecimalUtils.isLessThan(daySummary.getTotalMedicalCharges(), ppsRate) ? daySummary.getTotalMedicalCharges() : ppsRate;
        }
        if (StringUtils.equals("02", ioceServiceLine.getCompositeAdjustmentFlag())) {
            payment = BigDecimalUtils.isLessThan(daySummary.getTotalMentalCharges(), ppsRate) ? daySummary.getTotalMentalCharges() : ppsRate;
        }
        if (StringUtils.equals("03", ioceServiceLine.getCompositeAdjustmentFlag())) {
            payment = BigDecimalUtils.isLessThan(daySummary.getTotalMod59Charges(), ppsRate) ? daySummary.getTotalMod59Charges() : ppsRate;
        }
        if (LocalDateUtils.isAfterOrEqual(fqhcPricerContext.getClaimData().getServiceFromDate(), calculationContext.getFqhcPricerContext().getIopStartDate()) && StringUtils.equalsAny(ioceServiceLine.getCompositeAdjustmentFlag(), "04", "05")) {
            payment = BigDecimalUtils.isLessThan(daySummary.getTotalIopCharges(), ppsRate) ? daySummary.getTotalIopCharges() : ppsRate;
        }
        serviceLinePayment.setPayment(payment);
        calculationContext.setUnreducedPayment(payment);
    }
}

