/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.fqhc.core.rules.validation.rates.summary;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.fqhc.api.v2.IoceServiceLineData;
import gov.cms.fiss.pricers.fqhc.api.v2.ServiceLinePaymentData;
import gov.cms.fiss.pricers.fqhc.core.FqhcPricerContext;
import gov.cms.fiss.pricers.fqhc.core.ServiceLineContext;
import gov.cms.fiss.pricers.fqhc.core.daily.DaySummary;
import org.apache.commons.lang3.StringUtils;

public class ProcessPaymentAndPackageFlags
implements CalculationRule<IoceServiceLineData, ServiceLinePaymentData, ServiceLineContext> {
    @Override
    public void calculate(ServiceLineContext calculationContext) {
        IoceServiceLineData ioceServiceLine = (IoceServiceLineData)calculationContext.getInput();
        FqhcPricerContext fqhcPricerContext = calculationContext.getFqhcPricerContext();
        DaySummary summary = fqhcPricerContext.getDaySummary(ioceServiceLine.getDateOfService());
        if (!calculationContext.isCoinsuranceNAPaymentFlag() && StringUtils.equalsAny(ioceServiceLine.getPackageFlag(), "5") && StringUtils.equalsAny(ioceServiceLine.getPaymentIndicator(), "12")) {
            summary.setOtherPackageLinePresent(true);
        }
        if (calculationContext.isCoinsuranceNAPaymentFlag() && StringUtils.equalsAny(ioceServiceLine.getPackageFlag(), "5") && StringUtils.equalsAny(ioceServiceLine.getPaymentIndicator(), "12")) {
            summary.setCoinsuranceNotApplicablePackageLinePresent(true);
            summary.setTotalCoinsuranceNotApplicablePackageCharges(summary.getTotalCoinsuranceNotApplicablePackageCharges().add(ioceServiceLine.getCoveredCharges()));
        }
        if (StringUtils.equals(ioceServiceLine.getPackageFlag(), "6") && StringUtils.equalsAny(ioceServiceLine.getPaymentIndicator(), "12")) {
            summary.setPreventivePresent(true);
            summary.setCoinsuranceNotApplicablePackageLinePresent(true);
            summary.setTotalCoinsuranceNotApplicablePackageCharges(summary.getTotalCoinsuranceNotApplicablePackageCharges().add(ioceServiceLine.getCoveredCharges()));
        }
    }
}

