/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard;

import ch.qos.logback.classic.Level;
import io.dropwizard.Configuration;
import io.dropwizard.cli.CheckCommand;
import io.dropwizard.cli.Cli;
import io.dropwizard.cli.ServerCommand;
import io.dropwizard.logging.BootstrapLogging;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.dropwizard.util.Generics;
import io.dropwizard.util.JarLocation;

public abstract class Application<T extends Configuration> {
    protected Application() {
        this.bootstrapLogging();
    }

    protected Level bootstrapLogLevel() {
        return Level.WARN;
    }

    protected void bootstrapLogging() {
        BootstrapLogging.bootstrap(this.bootstrapLogLevel());
    }

    public Class<T> getConfigurationClass() {
        return Generics.getTypeParameter(this.getClass(), Configuration.class);
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public void initialize(Bootstrap<T> bootstrap) {
    }

    public abstract void run(T var1, Environment var2) throws Exception;

    public void run(String ... arguments) throws Exception {
        Bootstrap bootstrap = new Bootstrap(this);
        this.addDefaultCommands(bootstrap);
        this.initialize(bootstrap);
        bootstrap.registerMetrics();
        Cli cli = new Cli(new JarLocation(this.getClass()), bootstrap, System.out, System.err);
        cli.run(arguments).ifPresent(this::onFatalError);
    }

    protected void addDefaultCommands(Bootstrap<T> bootstrap) {
        bootstrap.addCommand(new ServerCommand(this));
        bootstrap.addCommand(new CheckCommand(this));
    }

    protected void onFatalError(Throwable t2) {
        this.onFatalError();
    }

    @Deprecated
    protected void onFatalError() {
        System.exit(1);
    }
}

