/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.memory;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Appender;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.localization.LogMessages;
import org.glassfish.grizzly.memory.BufferArray;
import org.glassfish.grizzly.memory.ByteBufferArray;
import org.glassfish.grizzly.memory.ByteBufferWrapper;
import org.glassfish.grizzly.memory.CompositeBuffer;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.memory.WrapperAware;

public class Buffers {
    private static final Logger LOGGER = Grizzly.logger(Buffers.class);
    private static final Appender<Buffer> APPENDER_DISPOSABLE = new BuffersAppender(true);
    private static final Appender<Buffer> APPENDER_NOT_DISPOSABLE = new BuffersAppender(false);
    public static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.allocate(0);
    public static final ByteBuffer[] EMPTY_BYTE_BUFFER_ARRAY = new ByteBuffer[0];
    public static final Buffer EMPTY_BUFFER = new ByteBufferWrapper(ByteBuffer.allocate(0)){

        @Override
        public void dispose() {
        }
    };

    public static Appender<Buffer> getBufferAppender(boolean isCompositeBufferDisposable) {
        return isCompositeBufferDisposable ? APPENDER_DISPOSABLE : APPENDER_NOT_DISPOSABLE;
    }

    public static Buffer wrap(MemoryManager memoryManager, String s2) {
        return Buffers.wrap(memoryManager, s2, Charset.defaultCharset());
    }

    public static Buffer wrap(MemoryManager memoryManager, String s2, Charset charset) {
        try {
            byte[] byteRepresentation = s2.getBytes(charset.name());
            return Buffers.wrap(memoryManager, byteRepresentation);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Buffer wrap(MemoryManager memoryManager, byte[] array) {
        return Buffers.wrap(memoryManager, array, 0, array.length);
    }

    public static Buffer wrap(MemoryManager memoryManager, byte[] array, int offset, int length) {
        if (memoryManager == null) {
            memoryManager = Buffers.getDefaultMemoryManager();
        }
        if (memoryManager instanceof WrapperAware) {
            return ((WrapperAware)((Object)memoryManager)).wrap(array, offset, length);
        }
        Object buffer = memoryManager.allocate(length);
        buffer.put(array, offset, length);
        buffer.flip();
        return buffer;
    }

    public static Buffer wrap(MemoryManager memoryManager, ByteBuffer byteBuffer) {
        if (memoryManager instanceof WrapperAware) {
            return ((WrapperAware)((Object)memoryManager)).wrap(byteBuffer);
        }
        if (byteBuffer.hasArray()) {
            return Buffers.wrap(memoryManager, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
        }
        throw new IllegalStateException("Can not wrap ByteBuffer");
    }

    public static ByteBuffer slice(ByteBuffer chunk, int size) {
        chunk.limit(chunk.position() + size);
        ByteBuffer view = chunk.slice();
        chunk.position(chunk.limit());
        chunk.limit(chunk.capacity());
        return view;
    }

    public static ByteBuffer slice(ByteBuffer byteBuffer, int position, int limit) {
        int oldPos = byteBuffer.position();
        int oldLimit = byteBuffer.limit();
        Buffers.setPositionLimit(byteBuffer, position, limit);
        ByteBuffer slice = byteBuffer.slice();
        Buffers.setPositionLimit(byteBuffer, oldPos, oldLimit);
        return slice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toStringContent(ByteBuffer byteBuffer, Charset charset, int position, int limit) {
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        int oldPosition = byteBuffer.position();
        int oldLimit = byteBuffer.limit();
        Buffers.setPositionLimit(byteBuffer, position, limit);
        try {
            String string = charset.decode(byteBuffer).toString();
            return string;
        }
        finally {
            Buffers.setPositionLimit(byteBuffer, oldPosition, oldLimit);
        }
    }

    public static void setPositionLimit(Buffer buffer, int position, int limit) {
        buffer.limit(limit);
        buffer.position(position);
    }

    public static void setPositionLimit(ByteBuffer buffer, int position, int limit) {
        buffer.limit(limit);
        buffer.position(position);
    }

    public static void put(ByteBuffer srcBuffer, int srcOffset, int length, ByteBuffer dstBuffer) {
        if (dstBuffer.remaining() < length) {
            LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_BUFFERS_OVERFLOW_EXCEPTION(srcBuffer, srcOffset, length, dstBuffer));
            throw new BufferOverflowException();
        }
        if (srcBuffer.hasArray() && dstBuffer.hasArray()) {
            System.arraycopy(srcBuffer.array(), srcBuffer.arrayOffset() + srcOffset, dstBuffer.array(), dstBuffer.arrayOffset() + dstBuffer.position(), length);
            dstBuffer.position(dstBuffer.position() + length);
        } else {
            for (int i2 = srcOffset; i2 < srcOffset + length; ++i2) {
                dstBuffer.put(srcBuffer.get(i2));
            }
        }
    }

    public static void put(Buffer src, int position, int length, Buffer dstBuffer) {
        if (dstBuffer.remaining() < length) {
            throw new BufferOverflowException();
        }
        if (!src.isComposite()) {
            ByteBuffer srcByteBuffer = src.toByteBuffer();
            if (srcByteBuffer.hasArray()) {
                dstBuffer.put(srcByteBuffer.array(), srcByteBuffer.arrayOffset() + position, length);
            } else {
                for (int i2 = 0; i2 < length; ++i2) {
                    dstBuffer.put(srcByteBuffer.get(position + i2));
                }
            }
        } else {
            ByteBufferArray array = src.toByteBufferArray(position, position + length);
            ByteBuffer[] srcByteBuffers = (ByteBuffer[])array.getArray();
            for (int i3 = 0; i3 < array.size(); ++i3) {
                ByteBuffer srcByteBuffer = srcByteBuffers[i3];
                int initialPosition = srcByteBuffer.position();
                int srcByteBufferLen = srcByteBuffer.remaining();
                if (srcByteBuffer.hasArray()) {
                    dstBuffer.put(srcByteBuffer.array(), srcByteBuffer.arrayOffset() + initialPosition, srcByteBufferLen);
                    continue;
                }
                int j = 0;
                while (j < srcByteBufferLen) {
                    dstBuffer.put(srcByteBuffer.get(initialPosition + j));
                    ++i3;
                }
            }
            array.restore();
            array.recycle();
        }
    }

    public static void get(ByteBuffer srcBuffer, byte[] dstBytes, int dstOffset, int length) {
        if (srcBuffer.hasArray()) {
            if (length > srcBuffer.remaining()) {
                throw new BufferUnderflowException();
            }
            System.arraycopy(srcBuffer.array(), srcBuffer.arrayOffset() + srcBuffer.position(), dstBytes, dstOffset, length);
            srcBuffer.position(srcBuffer.position() + length);
        } else {
            srcBuffer.get(dstBytes, dstOffset, length);
        }
    }

    public static void put(byte[] srcBytes, int srcOffset, int length, ByteBuffer dstBuffer) {
        if (dstBuffer.hasArray()) {
            if (length > dstBuffer.remaining()) {
                throw new BufferOverflowException();
            }
            System.arraycopy(srcBytes, srcOffset, dstBuffer.array(), dstBuffer.arrayOffset() + dstBuffer.position(), length);
            dstBuffer.position(dstBuffer.position() + length);
        } else {
            dstBuffer.put(srcBytes, srcOffset, length);
        }
    }

    public static Buffer appendBuffers(MemoryManager memoryManager, Buffer buffer1, Buffer buffer2) {
        return Buffers.appendBuffers(memoryManager, buffer1, buffer2, false);
    }

    public static Buffer appendBuffers(MemoryManager memoryManager, Buffer buffer1, Buffer buffer2, boolean isCompositeBufferDisposable) {
        if (buffer1 == null) {
            return buffer2;
        }
        if (buffer2 == null) {
            return buffer1;
        }
        if (buffer1.order() != buffer2.order()) {
            LOGGER.fine("Appending buffers with different ByteOrder.The result Buffer's order will be the same as the first Buffer's ByteOrder");
            buffer2.order(buffer1.order());
        }
        if (buffer1.isComposite() && buffer1.capacity() == buffer1.limit()) {
            ((CompositeBuffer)buffer1).append(buffer2);
            return buffer1;
        }
        if (buffer2.isComposite() && buffer2.position() == 0) {
            ((CompositeBuffer)buffer2).prepend(buffer1);
            return buffer2;
        }
        CompositeBuffer compositeBuffer = CompositeBuffer.newBuffer(memoryManager);
        compositeBuffer.order(buffer1.order());
        compositeBuffer.append(buffer1);
        compositeBuffer.append(buffer2);
        compositeBuffer.allowBufferDispose(isCompositeBufferDisposable);
        return compositeBuffer;
    }

    public static void fill(Buffer buffer, byte b) {
        Buffers.fill(buffer, buffer.position(), buffer.limit(), b);
    }

    public static void fill(Buffer buffer, int position, int limit, byte b) {
        if (!buffer.isComposite()) {
            ByteBuffer byteBuffer = buffer.toByteBuffer();
            Buffers.fill(byteBuffer, position, limit, b);
        } else {
            ByteBufferArray array = buffer.toByteBufferArray(position, limit);
            ByteBuffer[] byteBuffers = (ByteBuffer[])array.getArray();
            int size = array.size();
            for (int i2 = 0; i2 < size; ++i2) {
                ByteBuffer byteBuffer = byteBuffers[i2];
                Buffers.fill(byteBuffer, b);
            }
            array.restore();
            array.recycle();
        }
    }

    public static void fill(ByteBuffer byteBuffer, byte b) {
        Buffers.fill(byteBuffer, byteBuffer.position(), byteBuffer.limit(), b);
    }

    public static void fill(ByteBuffer byteBuffer, int position, int limit, byte b) {
        if (byteBuffer.hasArray()) {
            int arrayOffset = byteBuffer.arrayOffset();
            Arrays.fill(byteBuffer.array(), arrayOffset + position, arrayOffset + limit, b);
        } else {
            for (int i2 = position; i2 < limit; ++i2) {
                byteBuffer.put(i2, b);
            }
        }
    }

    public static Buffer cloneBuffer(Buffer srcBuffer) {
        return Buffers.cloneBuffer(srcBuffer, srcBuffer.position(), srcBuffer.limit());
    }

    public static Buffer cloneBuffer(Buffer srcBuffer, int position, int limit) {
        int srcLength = limit - position;
        if (srcLength == 0) {
            return Buffers.wrap(Buffers.getDefaultMemoryManager(), EMPTY_BYTE_BUFFER);
        }
        Object clone = Buffers.getDefaultMemoryManager().allocate(srcLength);
        clone.put(srcBuffer, position, srcLength);
        clone.order(srcBuffer.order());
        return clone.flip();
    }

    public static long readFromFileChannel(FileChannel fileChannel, Buffer buffer) throws IOException {
        long bytesRead;
        if (!buffer.isComposite()) {
            ByteBuffer bb = buffer.toByteBuffer();
            int oldPos = bb.position();
            bytesRead = fileChannel.read(bb);
            bb.position(oldPos);
        } else {
            ByteBufferArray array = buffer.toByteBufferArray();
            bytesRead = fileChannel.read((ByteBuffer[])array.getArray(), 0, array.size());
            array.restore();
            array.recycle();
        }
        if (bytesRead > 0L) {
            buffer.position(buffer.position() + (int)bytesRead);
        }
        return bytesRead;
    }

    public static long writeToFileChannel(FileChannel fileChannel, Buffer buffer) throws IOException {
        long bytesWritten;
        if (!buffer.isComposite()) {
            ByteBuffer bb = buffer.toByteBuffer();
            int oldPos = bb.position();
            bytesWritten = fileChannel.write(bb);
            bb.position(oldPos);
        } else {
            ByteBufferArray array = buffer.toByteBufferArray();
            bytesWritten = fileChannel.write((ByteBuffer[])array.getArray(), 0, array.size());
            array.restore();
            array.recycle();
        }
        if (bytesWritten > 0L) {
            buffer.position(buffer.position() + (int)bytesWritten);
        }
        return bytesWritten;
    }

    public String toStringContent(Buffer buffer, int headBytesCount, int tailBytesCount) {
        if (buffer == null) {
            return null;
        }
        return this.toStringContent(buffer, headBytesCount, tailBytesCount, Charset.defaultCharset());
    }

    public String toStringContent(Buffer buffer, int headBytesCount, int tailBytesCount, Charset charset) {
        if (buffer == null) {
            return null;
        }
        if (headBytesCount < 0 || tailBytesCount < 0) {
            throw new IllegalArgumentException("count can't be negative");
        }
        String toString = buffer.toString();
        StringBuilder sb = new StringBuilder(toString.length() + headBytesCount + tailBytesCount + 5);
        sb.append(toString);
        if (buffer.remaining() <= headBytesCount + tailBytesCount) {
            sb.append('[').append(buffer.toStringContent(charset)).append(']');
        } else {
            sb.append('[');
            if (headBytesCount > 0) {
                sb.append(buffer.toStringContent(charset, buffer.position(), buffer.position() + headBytesCount));
            }
            sb.append("...");
            if (tailBytesCount > 0) {
                sb.append(buffer.toStringContent(charset, buffer.limit() - tailBytesCount, buffer.limit()));
            }
            sb.append(']');
        }
        return sb.toString();
    }

    public static void dumpBuffer(Appendable appendable, Buffer buffer) {
        Formatter formatter = new Formatter(appendable);
        Buffers.dumpBuffer0(formatter, appendable, buffer);
    }

    private static void dumpBuffer0(Formatter formatter, Appendable appendable, Buffer buffer) {
        if (buffer.isComposite()) {
            BufferArray bufferArray = buffer.toBufferArray();
            int size = bufferArray.size();
            Buffer[] buffers = (Buffer[])bufferArray.getArray();
            formatter.format("%s\n", buffer.toString());
            for (int i2 = 0; i2 < size; ++i2) {
                Buffers.dumpBuffer0(formatter, appendable, buffers[i2]);
            }
            formatter.format("End CompositeBuffer (%d)", System.identityHashCode(buffer));
        } else {
            Buffers.dumpBuffer0(formatter, buffer);
        }
    }

    private static void dumpBuffer0(Formatter formatter, Buffer buffer) {
        formatter.format("%s\n", buffer.toString());
        int line = 0;
        int i2 = 0;
        int len = buffer.remaining() / 16;
        while (i2 < len) {
            byte b0 = buffer.get(line);
            byte b1 = buffer.get(line + 1);
            byte b2 = buffer.get(line + 2);
            byte b3 = buffer.get(line + 3);
            byte b4 = buffer.get(line + 4);
            byte b5 = buffer.get(line + 5);
            byte b6 = buffer.get(line + 6);
            byte b7 = buffer.get(line + 7);
            byte b8 = buffer.get(line + 8);
            byte b9 = buffer.get(line + 9);
            byte b10 = buffer.get(line + 10);
            byte b11 = buffer.get(line + 11);
            byte b12 = buffer.get(line + 12);
            byte b13 = buffer.get(line + 13);
            byte b14 = buffer.get(line + 14);
            byte b15 = buffer.get(line + 15);
            formatter.format(DumpStrings.DUMP_STRINGS[15], line, b0, b1, b2, b3, b4, b5, b6, b7, b8, b9, b10, b11, b12, b13, b14, b15, Character.valueOf(Buffers.getChar(b0)), Character.valueOf(Buffers.getChar(b1)), Character.valueOf(Buffers.getChar(b2)), Character.valueOf(Buffers.getChar(b3)), Character.valueOf(Buffers.getChar(b4)), Character.valueOf(Buffers.getChar(b5)), Character.valueOf(Buffers.getChar(b6)), Character.valueOf(Buffers.getChar(b7)), Character.valueOf(Buffers.getChar(b8)), Character.valueOf(Buffers.getChar(b9)), Character.valueOf(Buffers.getChar(b10)), Character.valueOf(Buffers.getChar(b11)), Character.valueOf(Buffers.getChar(b12)), Character.valueOf(Buffers.getChar(b13)), Character.valueOf(Buffers.getChar(b14)), Character.valueOf(Buffers.getChar(b15)));
            ++i2;
            line += 16;
        }
        int remaining = buffer.remaining() % 16;
        if (remaining > 0) {
            Object[] args = new Object[(remaining << 1) + 1];
            args[0] = remaining + line;
            int i3 = 0;
            int aIdx = 1;
            while (i3 < remaining) {
                byte b = buffer.get(line + i3);
                args[aIdx] = b & 0xFF;
                args[aIdx + remaining] = Character.valueOf(Buffers.getChar(b));
                ++i3;
                ++aIdx;
            }
            formatter.format(DumpStrings.DUMP_STRINGS[remaining - 1], args);
        }
    }

    private static char getChar(int val) {
        char c = (char)val;
        return Character.isWhitespace(c) || Character.isISOControl(c) ? (char)'.' : c;
    }

    private static MemoryManager getDefaultMemoryManager() {
        return MemoryManager.DEFAULT_MEMORY_MANAGER;
    }

    private static final class DumpStrings {
        private static final String[] DUMP_STRINGS = new String[]{"%10d   %02x                                                         %c\n", "%10d   %02x %02x                                                      %c%c\n", "%10d   %02x %02x  %02x                                                  %c%c%c\n", "%10d   %02x %02x  %02x %02x                                               %c%c%c%c\n", "%10d   %02x %02x  %02x %02x  %02x                                           %c%c%c%c%c\n", "%10d   %02x %02x  %02x %02x  %02x %02x                                        %c%c%c%c%c%c\n", "%10d   %02x %02x  %02x %02x  %02x %02x  %02x                                    %c%c%c%c%c%c%c\n", "%10d   %02x %02x  %02x %02x  %02x %02x  %02x %02x                                 %c%c%c%c%c%c%c%c\n", "%10d   %02x %02x  %02x %02x  %02x %02x  %02x %02x    %02x                           %c%c%c%c%c%c%c%c%c\n", "%10d   %02x %02x  %02x %02x  %02x %02x  %02x %02x    %02x %02x                        %c%c%c%c%c%c%c%c%c%c\n", "%10d   %02x %02x  %02x %02x  %02x %02x  %02x %02x    %02x %02x  %02x                    %c%c%c%c%c%c%c%c%c%c%c\n", "%10d   %02x %02x  %02x %02x  %02x %02x  %02x %02x    %02x %02x  %02x %02x                 %c%c%c%c%c%c%c%c%c%c%c%c\n", "%10d   %02x %02x  %02x %02x  %02x %02x  %02x %02x    %02x %02x  %02x %02x  %02x             %c%c%c%c%c%c%c%c%c%c%c%c%c\n", "%10d   %02x %02x  %02x %02x  %02x %02x  %02x %02x    %02x %02x  %02x %02x  %02x %02x          %c%c%c%c%c%c%c%c%c%c%c%c%c%c\n", "%10d   %02x %02x  %02x %02x  %02x %02x  %02x %02x    %02x %02x  %02x %02x  %02x %02x  %02x      %c%c%c%c%c%c%c%c%c%c%c%c%c%c%c\n", "%10d   %02x %02x  %02x %02x  %02x %02x  %02x %02x    %02x %02x  %02x %02x  %02x %02x  %02x %02x   %c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c\n"};

        private DumpStrings() {
        }
    }

    private static class BuffersAppender
    implements Appender<Buffer> {
        private final boolean isCompositeBufferDisposable;

        public BuffersAppender(boolean isCompositeBufferDisposable) {
            this.isCompositeBufferDisposable = isCompositeBufferDisposable;
        }

        @Override
        public Buffer append(Buffer element1, Buffer element2) {
            return Buffers.appendBuffers(null, element1, element2, this.isCompositeBufferDisposable);
        }
    }
}

