/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.utils;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;

public class Exceptions {
    public static String getStackTraceAsString(Throwable t2) {
        StringWriter stringWriter = new StringWriter(2048);
        PrintWriter pw = new PrintWriter(stringWriter);
        t2.printStackTrace(pw);
        pw.close();
        return stringWriter.toString();
    }

    public static IOException makeIOException(Throwable t2) {
        if (IOException.class.isAssignableFrom(t2.getClass())) {
            return (IOException)t2;
        }
        return new IOException(t2);
    }

    public static String getAllStackTracesAsString() {
        StringBuilder sb = new StringBuilder(256);
        Map<Thread, StackTraceElement[]> all = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> entry : all.entrySet()) {
            sb.append(entry.getKey()).append('\n');
            for (StackTraceElement traceElement : entry.getValue()) {
                sb.append("\tat ").append(traceElement).append('\n');
            }
        }
        return sb.toString();
    }
}

