/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.validation.internal;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.validation.Configuration;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import javax.validation.executable.ExecutableValidator;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.MethodDescriptor;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.server.internal.inject.ConfiguredValidator;
import org.glassfish.jersey.server.model.Invocable;
import org.glassfish.jersey.server.spi.ValidationInterceptor;
import org.glassfish.jersey.server.spi.ValidationInterceptorContext;
import org.glassfish.jersey.server.validation.internal.ValidateOnExecutionHandler;
import org.glassfish.jersey.server.validation.internal.ValidationInterceptorExecutor;

class DefaultConfiguredValidator
implements ConfiguredValidator,
ValidationInterceptor {
    private final Validator delegate;
    private final Configuration configuration;
    private final ValidateOnExecutionHandler validateOnExecutionHandler;
    private final List<ValidationInterceptor> interceptors;

    DefaultConfiguredValidator(Validator delegate, Configuration configuration, ValidateOnExecutionHandler validateOnExecutionHandler, Iterable<ValidationInterceptor> interceptors) {
        this.delegate = delegate;
        this.configuration = configuration;
        this.validateOnExecutionHandler = validateOnExecutionHandler;
        this.interceptors = this.createInterceptorList(interceptors);
    }

    private List<ValidationInterceptor> createInterceptorList(Iterable<ValidationInterceptor> interceptors) {
        LinkedList<ValidationInterceptor> result = new LinkedList<ValidationInterceptor>();
        for (ValidationInterceptor i2 : interceptors) {
            result.add(i2);
        }
        result.add(this);
        return result;
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validate(T object, Class<?> ... groups) {
        return this.delegate.validate(object, groups);
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validateProperty(T object, String propertyName, Class<?> ... groups) {
        return this.delegate.validateProperty(object, propertyName, groups);
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validateValue(Class<T> beanType, String propertyName, Object value, Class<?> ... groups) {
        return this.delegate.validateValue(beanType, propertyName, value, groups);
    }

    @Override
    public BeanDescriptor getConstraintsForClass(Class<?> clazz) {
        return this.delegate.getConstraintsForClass(clazz);
    }

    @Override
    public <T> T unwrap(Class<T> type) {
        return this.delegate.unwrap(type);
    }

    @Override
    public ExecutableValidator forExecutables() {
        return this.delegate.forExecutables();
    }

    @Override
    public void validateResourceAndInputParams(Object resource, Invocable resourceMethod, Object[] args) {
        ValidationInterceptorExecutor validationExecutor = new ValidationInterceptorExecutor(resource, resourceMethod, args, this.interceptors.iterator());
        validationExecutor.proceed();
    }

    @Override
    public void onValidate(ValidationInterceptorContext ctx) {
        Method handlingMethod;
        MethodDescriptor methodDescriptor;
        Object resource = ctx.getResource();
        Invocable resourceMethod = ctx.getInvocable();
        Object[] args = ctx.getArgs();
        HashSet<ConstraintViolation<Object>> constraintViolations = new HashSet<ConstraintViolation<Object>>();
        BeanDescriptor beanDescriptor = this.getConstraintsForClass(resource.getClass());
        if (beanDescriptor.isBeanConstrained()) {
            constraintViolations.addAll(this.validate(resource, new Class[0]));
        }
        if (resourceMethod != null && this.configuration.getBootstrapConfiguration().isExecutableValidationEnabled() && (methodDescriptor = beanDescriptor.getConstraintsForMethod((handlingMethod = resourceMethod.getHandlingMethod()).getName(), handlingMethod.getParameterTypes())) != null && methodDescriptor.hasConstrainedParameters() && this.validateOnExecutionHandler.validateMethod(resource.getClass(), resourceMethod.getDefinitionMethod(), resourceMethod.getHandlingMethod())) {
            constraintViolations.addAll(this.forExecutables().validateParameters(resource, handlingMethod, args, new Class[0]));
        }
        if (!constraintViolations.isEmpty()) {
            throw new ConstraintViolationException(constraintViolations);
        }
    }

    @Override
    public void validateResult(Object resource, Invocable resourceMethod, Object result) {
        if (this.configuration.getBootstrapConfiguration().isExecutableValidationEnabled()) {
            HashSet<ConstraintViolation<Object>> constraintViolations = new HashSet<ConstraintViolation<Object>>();
            Method handlingMethod = resourceMethod.getHandlingMethod();
            BeanDescriptor beanDescriptor = this.getConstraintsForClass(resource.getClass());
            MethodDescriptor methodDescriptor = beanDescriptor.getConstraintsForMethod(handlingMethod.getName(), handlingMethod.getParameterTypes());
            Method definitionMethod = resourceMethod.getDefinitionMethod();
            if (methodDescriptor != null && methodDescriptor.hasConstrainedReturnValue() && this.validateOnExecutionHandler.validateMethod(resource.getClass(), definitionMethod, handlingMethod)) {
                constraintViolations.addAll(this.forExecutables().validateReturnValue(resource, handlingMethod, result, new Class[0]));
                if (result instanceof Response) {
                    constraintViolations.addAll(this.forExecutables().validateReturnValue(resource, handlingMethod, ((Response)result).getEntity(), new Class[0]));
                }
            }
            if (!constraintViolations.isEmpty()) {
                throw new ConstraintViolationException(constraintViolations);
            }
        }
    }
}

