// Generated by delombok at Tue May 20 17:40:00 UTC 2025
package gov.cms.fiss.pricers.fqhc.api.v2;

import gov.cms.fiss.pricers.common.api.ClaimData;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.serialization.StrictLocalDate;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

@Schema(description = "The FQHC claim data to process for pricing.", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "I-CLAIM-LEVEL-INPUT", value = "<structure>)")})})
public class FqhcClaimData extends ClaimData {
  @NotNull
  @Pattern(regexp = "\\d{5}", message = "must be five digits")
  @Schema(description = "The carrier\'s code.", example = "02102", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "I-CARRIER", value = "PIC X(05)")})})
  private String carrierCode;
  @ArraySchema(arraySchema = @Schema(description = "The demo codes related to the claim.", example = "[ \"83\", \"66\", \"29\", \"15\" ]"), uniqueItems = true)
  @Size(max = 4, min = 1)
  private List<@Pattern(regexp = "\\d{2}", message = "must be a two-digit string") String> demoCodes;
  @ArraySchema(arraySchema = @Schema(description = "The services provided."), extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "I-SERVICE-LINE", value = "<structure>")})}, uniqueItems = true)
  @NotEmpty
  @Size(max = 450)
  @Valid
  private List<@NotNull IoceServiceLineData> ioceServiceLines;
  @NotNull
  @Pattern(regexp = "\\d{2}", message = "must be two digits")
  @Schema(description = "The locality\'s code.", example = "01", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "I-LOCALITY", value = "PIC X(02)")})})
  private String localityCode;
  @BigDecimalScale
  @DecimalMax("1.00")
  @DecimalMin("0")
  @Digits(integer = 1, fraction = 2)
  @Schema(description = "The Maryland Primary-Care Program (MDPCP) reduction percent.", example = "0.25")
  private BigDecimal mdpcpReductionPercent;
  @BigDecimalScale
  @DecimalMax("999999999.99")
  @DecimalMin("0")
  @Digits(integer = 9, fraction = 2)
  @NotNull
  @Schema(description = "The Medicare Advantage plan amount.", example = "150.99", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "I-MA-PLAN-AMT", value = "PIC 9(09)V99")})})
  private BigDecimal medicareAdvantagePlanAmount;
  @NotNull
  @Schema(description = "The start date of service.", example = "2020-05-13", format = "yyyy-MM-dd", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "I-SRVC-FROM-DATET", value = "PIC 9(08)")})})
  @StrictLocalDate
  private LocalDate serviceFromDate;
  @NotNull
  @Schema(description = "The end date of service.", example = "2020-06-13", format = "yyyy-MM-dd", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "I-SRVC-THRU-DATE", value = "PIC 9(08)")})})
  @StrictLocalDate
  private LocalDate serviceThroughDate;

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCarrierCode() {
    return this.carrierCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<@Pattern(regexp = "\\d{2}", message = "must be a two-digit string") String> getDemoCodes() {
    return this.demoCodes;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<@NotNull IoceServiceLineData> getIoceServiceLines() {
    return this.ioceServiceLines;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getLocalityCode() {
    return this.localityCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getMdpcpReductionPercent() {
    return this.mdpcpReductionPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getMedicareAdvantagePlanAmount() {
    return this.medicareAdvantagePlanAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LocalDate getServiceFromDate() {
    return this.serviceFromDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LocalDate getServiceThroughDate() {
    return this.serviceThroughDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCarrierCode(final String carrierCode) {
    this.carrierCode = carrierCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDemoCodes(final List<@Pattern(regexp = "\\d{2}", message = "must be a two-digit string") String> demoCodes) {
    this.demoCodes = demoCodes;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setIoceServiceLines(final List<@NotNull IoceServiceLineData> ioceServiceLines) {
    this.ioceServiceLines = ioceServiceLines;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLocalityCode(final String localityCode) {
    this.localityCode = localityCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMdpcpReductionPercent(final BigDecimal mdpcpReductionPercent) {
    this.mdpcpReductionPercent = mdpcpReductionPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMedicareAdvantagePlanAmount(final BigDecimal medicareAdvantagePlanAmount) {
    this.medicareAdvantagePlanAmount = medicareAdvantagePlanAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setServiceFromDate(final LocalDate serviceFromDate) {
    this.serviceFromDate = serviceFromDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setServiceThroughDate(final LocalDate serviceThroughDate) {
    this.serviceThroughDate = serviceThroughDate;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof FqhcClaimData)) return false;
    final FqhcClaimData other = (FqhcClaimData) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    if (!super.equals(o)) return false;
    final java.lang.Object this$carrierCode = this.getCarrierCode();
    final java.lang.Object other$carrierCode = other.getCarrierCode();
    if (this$carrierCode == null ? other$carrierCode != null : !this$carrierCode.equals(other$carrierCode)) return false;
    final java.lang.Object this$demoCodes = this.getDemoCodes();
    final java.lang.Object other$demoCodes = other.getDemoCodes();
    if (this$demoCodes == null ? other$demoCodes != null : !this$demoCodes.equals(other$demoCodes)) return false;
    final java.lang.Object this$ioceServiceLines = this.getIoceServiceLines();
    final java.lang.Object other$ioceServiceLines = other.getIoceServiceLines();
    if (this$ioceServiceLines == null ? other$ioceServiceLines != null : !this$ioceServiceLines.equals(other$ioceServiceLines)) return false;
    final java.lang.Object this$localityCode = this.getLocalityCode();
    final java.lang.Object other$localityCode = other.getLocalityCode();
    if (this$localityCode == null ? other$localityCode != null : !this$localityCode.equals(other$localityCode)) return false;
    final java.lang.Object this$mdpcpReductionPercent = this.getMdpcpReductionPercent();
    final java.lang.Object other$mdpcpReductionPercent = other.getMdpcpReductionPercent();
    if (this$mdpcpReductionPercent == null ? other$mdpcpReductionPercent != null : !this$mdpcpReductionPercent.equals(other$mdpcpReductionPercent)) return false;
    final java.lang.Object this$medicareAdvantagePlanAmount = this.getMedicareAdvantagePlanAmount();
    final java.lang.Object other$medicareAdvantagePlanAmount = other.getMedicareAdvantagePlanAmount();
    if (this$medicareAdvantagePlanAmount == null ? other$medicareAdvantagePlanAmount != null : !this$medicareAdvantagePlanAmount.equals(other$medicareAdvantagePlanAmount)) return false;
    final java.lang.Object this$serviceFromDate = this.getServiceFromDate();
    final java.lang.Object other$serviceFromDate = other.getServiceFromDate();
    if (this$serviceFromDate == null ? other$serviceFromDate != null : !this$serviceFromDate.equals(other$serviceFromDate)) return false;
    final java.lang.Object this$serviceThroughDate = this.getServiceThroughDate();
    final java.lang.Object other$serviceThroughDate = other.getServiceThroughDate();
    if (this$serviceThroughDate == null ? other$serviceThroughDate != null : !this$serviceThroughDate.equals(other$serviceThroughDate)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof FqhcClaimData;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = super.hashCode();
    final java.lang.Object $carrierCode = this.getCarrierCode();
    result = result * PRIME + ($carrierCode == null ? 43 : $carrierCode.hashCode());
    final java.lang.Object $demoCodes = this.getDemoCodes();
    result = result * PRIME + ($demoCodes == null ? 43 : $demoCodes.hashCode());
    final java.lang.Object $ioceServiceLines = this.getIoceServiceLines();
    result = result * PRIME + ($ioceServiceLines == null ? 43 : $ioceServiceLines.hashCode());
    final java.lang.Object $localityCode = this.getLocalityCode();
    result = result * PRIME + ($localityCode == null ? 43 : $localityCode.hashCode());
    final java.lang.Object $mdpcpReductionPercent = this.getMdpcpReductionPercent();
    result = result * PRIME + ($mdpcpReductionPercent == null ? 43 : $mdpcpReductionPercent.hashCode());
    final java.lang.Object $medicareAdvantagePlanAmount = this.getMedicareAdvantagePlanAmount();
    result = result * PRIME + ($medicareAdvantagePlanAmount == null ? 43 : $medicareAdvantagePlanAmount.hashCode());
    final java.lang.Object $serviceFromDate = this.getServiceFromDate();
    result = result * PRIME + ($serviceFromDate == null ? 43 : $serviceFromDate.hashCode());
    final java.lang.Object $serviceThroughDate = this.getServiceThroughDate();
    result = result * PRIME + ($serviceThroughDate == null ? 43 : $serviceThroughDate.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "FqhcClaimData(carrierCode=" + this.getCarrierCode() + ", demoCodes=" + this.getDemoCodes() + ", ioceServiceLines=" + this.getIoceServiceLines() + ", localityCode=" + this.getLocalityCode() + ", mdpcpReductionPercent=" + this.getMdpcpReductionPercent() + ", medicareAdvantagePlanAmount=" + this.getMedicareAdvantagePlanAmount() + ", serviceFromDate=" + this.getServiceFromDate() + ", serviceThroughDate=" + this.getServiceThroughDate() + ")";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public FqhcClaimData() {
  }
}
