/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.grizzly;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Request;
import com.ning.http.client.providers.grizzly.AhcHttpContext;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProvider;
import com.ning.http.client.providers.grizzly.GrizzlyResponseFuture;
import com.ning.http.client.providers.grizzly.GrizzlyResponseStatus;
import com.ning.http.client.providers.grizzly.PayloadGenerator;
import com.ning.http.client.providers.grizzly.StatusHandler;
import com.ning.http.client.providers.grizzly.events.GracefulCloseEvent;
import com.ning.http.client.uri.Uri;
import com.ning.http.client.ws.WebSocket;
import com.ning.http.util.AsyncHttpProviderUtils;
import com.ning.http.util.ProxyUtils;
import java.io.IOException;
import org.glassfish.grizzly.CloseListener;
import org.glassfish.grizzly.CloseType;
import org.glassfish.grizzly.Closeable;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.http.HttpContext;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.websockets.HandShake;
import org.glassfish.grizzly.websockets.ProtocolHandler;

public final class HttpTransactionContext {
    private static final Attribute<HttpTransactionContext> REQUEST_STATE_ATTR = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(HttpTransactionContext.class.getName());
    int redirectCount;
    final int maxRedirectCount;
    final boolean redirectsAllowed;
    final GrizzlyAsyncHttpProvider provider;
    final ProxyServer proxyServer;
    private final Request ahcRequest;
    Uri requestUri;
    private final Connection connection;
    PayloadGenerator payloadGenerator;
    StatusHandler statusHandler;
    StatusHandler.InvocationStatus invocationStatus = StatusHandler.InvocationStatus.CONTINUE;
    GrizzlyResponseFuture future;
    HttpResponsePacket responsePacket;
    GrizzlyResponseStatus responseStatus;
    Uri lastRedirectUri;
    long totalBodyWritten;
    AsyncHandler.STATE currentState;
    Uri wsRequestURI;
    boolean isWSRequest;
    HandShake handshake;
    ProtocolHandler protocolHandler;
    WebSocket webSocket;
    boolean establishingTunnel;
    boolean skipCleanup;
    boolean isReuseConnection;
    private boolean isRequestFullySent;
    private CleanupTask cleanupTask;
    private final CloseListener listener = new CloseListener<Closeable, CloseType>(){

        @Override
        public void onClosed(Closeable closeable, CloseType type) throws IOException {
            if (HttpTransactionContext.this.isGracefullyFinishResponseOnClose() || HttpTransactionContext.this.isKeepAliveDisabled()) {
                FilterChain fc = (FilterChain)HttpTransactionContext.this.connection.getProcessor();
                fc.fireEventUpstream(HttpTransactionContext.this.connection, new GracefulCloseEvent(HttpTransactionContext.this), null);
            } else if (CloseType.REMOTELY.equals(type)) {
                HttpTransactionContext.this.abort(AsyncHttpProviderUtils.REMOTELY_CLOSED_EXCEPTION);
            } else {
                try {
                    closeable.assertOpen();
                }
                catch (IOException ioe) {
                    HttpTransactionContext.this.abort(ioe.getCause());
                }
            }
        }
    };

    static void bind(HttpContext httpCtx, HttpTransactionContext httpTxContext) {
        httpCtx.getCloseable().addCloseListener(httpTxContext.listener);
        REQUEST_STATE_ATTR.set(httpCtx, httpTxContext);
    }

    static void cleanupTransaction(HttpContext httpCtx, CompletionHandler<HttpTransactionContext> completionHandler) {
        HttpTransactionContext httpTxContext = HttpTransactionContext.currentTransaction(httpCtx);
        assert (httpTxContext != null);
        httpTxContext.scheduleCleanup(httpCtx, completionHandler);
    }

    static HttpTransactionContext currentTransaction(HttpHeader httpHeader) {
        return HttpTransactionContext.currentTransaction(httpHeader.getProcessingState().getHttpContext());
    }

    static HttpTransactionContext currentTransaction(AttributeStorage storage) {
        return REQUEST_STATE_ATTR.get(storage);
    }

    static HttpTransactionContext currentTransaction(HttpContext httpCtx) {
        return ((AhcHttpContext)httpCtx).getHttpTransactionContext();
    }

    static HttpTransactionContext startTransaction(Connection connection, GrizzlyAsyncHttpProvider provider, Request request, GrizzlyResponseFuture future) {
        return new HttpTransactionContext(provider, connection, future, request);
    }

    private HttpTransactionContext(GrizzlyAsyncHttpProvider provider, Connection connection, GrizzlyResponseFuture future, Request ahcRequest) {
        this.provider = provider;
        this.connection = connection;
        this.future = future;
        this.ahcRequest = ahcRequest;
        this.proxyServer = ProxyUtils.getProxyServer(provider.getClientConfig(), ahcRequest);
        this.redirectsAllowed = provider.getClientConfig().isFollowRedirect();
        this.maxRedirectCount = provider.getClientConfig().getMaxRedirects();
        this.requestUri = ahcRequest.getUri();
    }

    Connection getConnection() {
        return this.connection;
    }

    public AsyncHandler getAsyncHandler() {
        return this.future != null ? this.future.getAsyncHandler() : null;
    }

    Request getAhcRequest() {
        return this.ahcRequest;
    }

    ProxyServer getProxyServer() {
        return this.proxyServer;
    }

    HttpTransactionContext cloneAndStartTransactionFor(Connection connection) {
        return this.cloneAndStartTransactionFor(connection, this.ahcRequest);
    }

    HttpTransactionContext cloneAndStartTransactionFor(Connection connection, Request request) {
        HttpTransactionContext newContext = HttpTransactionContext.startTransaction(connection, this.provider, request, this.future);
        newContext.invocationStatus = this.invocationStatus;
        newContext.payloadGenerator = this.payloadGenerator;
        newContext.currentState = this.currentState;
        newContext.statusHandler = this.statusHandler;
        newContext.lastRedirectUri = this.lastRedirectUri;
        newContext.redirectCount = this.redirectCount;
        this.future = null;
        return newContext;
    }

    boolean isGracefullyFinishResponseOnClose() {
        HttpResponsePacket response = this.responsePacket;
        return response != null && !response.getProcessingState().isKeepAlive() && !response.isChunked() && response.getContentLength() == -1L;
    }

    void abort(Throwable t2) {
        if (this.future != null) {
            this.future.abort(t2);
        }
    }

    void done() {
        this.done(null);
    }

    void done(Object result) {
        if (this.future != null) {
            this.future.done(result);
        }
    }

    boolean isTunnelEstablished(Connection c) {
        return c.getAttributes().getAttribute("tunnel-established") != null;
    }

    void tunnelEstablished(Connection c) {
        c.getAttributes().setAttribute("tunnel-established", Boolean.TRUE);
    }

    void reuseConnection() {
        this.isReuseConnection = true;
    }

    boolean isReuseConnection() {
        return this.isReuseConnection;
    }

    void touchConnection() {
        this.provider.touchConnection(this.connection, this.ahcRequest);
    }

    void closeConnection() {
        this.connection.closeSilently();
    }

    void keepAliveDisabled() {
        this.connection.getAttributes().setAttribute("keep-alive-disabled", Boolean.TRUE);
    }

    boolean isKeepAliveDisabled() {
        return Boolean.TRUE.equals(this.connection.getAttributes().getAttribute("keep-alive-disabled"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleCleanup(HttpContext httpCtx, CompletionHandler<HttpTransactionContext> completionHandler) {
        HttpTransactionContext httpTransactionContext = this;
        synchronized (httpTransactionContext) {
            if (!this.isRequestFullySent) {
                assert (this.cleanupTask == null);
                this.cleanupTask = new CleanupTask(httpCtx, completionHandler);
                return;
            }
        }
        assert (this.isRequestFullySent);
        this.cleanup(httpCtx);
        completionHandler.completed(this);
    }

    private void cleanup(HttpContext httpCtx) {
        if (!this.skipCleanup) {
            httpCtx.getCloseable().removeCloseListener(this.listener);
            REQUEST_STATE_ATTR.remove(httpCtx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onRequestFullySent() {
        HttpTransactionContext httpTransactionContext = this;
        synchronized (httpTransactionContext) {
            if (this.isRequestFullySent) {
                return;
            }
            this.isRequestFullySent = true;
        }
        if (this.cleanupTask != null) {
            this.cleanupTask.run();
        }
    }

    private class CleanupTask
    implements Runnable {
        private final HttpContext httpCtx;
        private final CompletionHandler<HttpTransactionContext> completionHandler;

        private CleanupTask(HttpContext httpCtx, CompletionHandler<HttpTransactionContext> completionHandler) {
            this.httpCtx = httpCtx;
            this.completionHandler = completionHandler;
        }

        @Override
        public void run() {
            HttpTransactionContext.this.cleanup(this.httpCtx);
            this.completionHandler.completed(HttpTransactionContext.this);
        }
    }
}

