/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.application.resources;

import com.codahale.metrics.annotation.Timed;
import com.codahale.metrics.health.HealthCheckRegistry;
import gov.cms.fiss.pricers.common.application.resources.HealthCheckResults;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="v1/health")
@Produces(value={"application/json"})
public class DefaultPricerHealthResource {
    private final HealthCheckRegistry registry;

    public DefaultPricerHealthResource(HealthCheckRegistry registry) {
        this.registry = registry;
    }

    @GET
    @Timed(name="health")
    @Operation(summary="Health check endpoint.", description="Determines if the pricer application is healthy.", deprecated=true, responses={@ApiResponse(responseCode="200", description="Pricer is healthy; details in response content.", content={@Content(mediaType="application/json", schema=@Schema(name="healthCheckResult", description="Health result from individual check.", implementation=HealthCheckResults.class))}), @ApiResponse(responseCode="503", description="Pricer is unhealthy; details in response content.", content={@Content(mediaType="application/json", schema=@Schema(name="healthCheckResult", description="Health result from individual check.", implementation=HealthCheckResults.class))})})
    public Response getHealth() {
        HealthCheckResults aggregateResults = HealthCheckResults.fromHealthChecks(this.registry.runHealthChecks());
        if (!aggregateResults.isHealthy()) {
            return Response.status(Response.Status.SERVICE_UNAVAILABLE).entity(aggregateResults).build();
        }
        return Response.ok(aggregateResults).build();
    }
}

