/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public final class JsonUtils {
    public static List<List<String>> getJsonPaths(JsonNode node) {
        return JsonUtils.findPaths(new ArrayList<String>(), node);
    }

    private static List<List<String>> findPaths(List<String> parentPath, JsonNode node) {
        ArrayList<List<String>> paths = new ArrayList<List<String>>();
        Iterator<Map.Entry<String, JsonNode>> it = node.fields();
        while (it.hasNext()) {
            Map.Entry<String, JsonNode> fieldRef = it.next();
            ArrayList<String> fieldPath = new ArrayList<String>(parentPath);
            fieldPath.add(fieldRef.getKey());
            if (fieldRef.getValue().isContainerNode()) {
                paths.addAll(JsonUtils.findPaths(fieldPath, fieldRef.getValue()));
                continue;
            }
            paths.add(fieldPath);
        }
        return paths;
    }

    public static JsonNode findNode(JsonNode node, String nodePath) {
        return JsonUtils.findNode(node, StringUtils.split(nodePath, "."));
    }

    public static JsonNode findNode(JsonNode node, String[] nodePath) {
        return JsonUtils.findNode(node, Arrays.asList(nodePath));
    }

    public static JsonNode findNode(JsonNode node, List<String> nodePath) {
        if (null == node) {
            return null;
        }
        ArrayList<String> remainingPath = new ArrayList<String>(nodePath);
        String nextPath = (String)remainingPath.remove(0);
        JsonNode child = node.findPath(nextPath);
        if (child instanceof MissingNode) {
            return null;
        }
        if (remainingPath.isEmpty()) {
            return child;
        }
        return JsonUtils.findNode(child, remainingPath);
    }

    @Generated
    private JsonUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

