/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.fqhc.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.LocalDateUtils;
import gov.cms.fiss.pricers.fqhc.api.v2.FqhcClaimData;
import gov.cms.fiss.pricers.fqhc.api.v2.FqhcClaimPricingRequest;
import gov.cms.fiss.pricers.fqhc.api.v2.FqhcClaimPricingResponse;
import gov.cms.fiss.pricers.fqhc.core.FqhcPricerContext;
import gov.cms.fiss.pricers.fqhc.core.ReturnCode;

public class DefaultServiceDateValidation
implements CalculationRule<FqhcClaimPricingRequest, FqhcClaimPricingResponse, FqhcPricerContext> {
    @Override
    public void calculate(FqhcPricerContext calculationContext) {
        FqhcClaimData inputRecord = calculationContext.getClaimData();
        if (LocalDateUtils.isAfterOrEqual(inputRecord.getServiceFromDate(), calculationContext.getFqhcStartDate())) {
            calculationContext.applyClaimReturnCode(ReturnCode.CLAIM_OK_01);
        } else {
            calculationContext.applyClaimReturnCode(ReturnCode.CLAIM_INVALID_SERVICE_DATE_02);
            calculationContext.setCalculationCompleted();
        }
    }
}

