/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.fqhc.core.rules.processing;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.fqhc.api.v2.IoceServiceLineData;
import gov.cms.fiss.pricers.fqhc.api.v2.ServiceLinePaymentData;
import gov.cms.fiss.pricers.fqhc.core.FqhcPricerContext;
import gov.cms.fiss.pricers.fqhc.core.ReturnCode;
import gov.cms.fiss.pricers.fqhc.core.ServiceLineContext;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;

public class CalculateMedicareAdvantageLinePayment
implements CalculationRule<IoceServiceLineData, ServiceLinePaymentData, ServiceLineContext> {
    @Override
    public void calculate(ServiceLineContext calculationContext) {
        IoceServiceLineData ioceServiceLine = (IoceServiceLineData)calculationContext.getInput();
        ServiceLinePaymentData serviceLinePayment = (ServiceLinePaymentData)calculationContext.getOutput();
        FqhcPricerContext fqhcPricerContext = calculationContext.getFqhcPricerContext();
        if (fqhcPricerContext.isMaClaim() && StringUtils.equals(ioceServiceLine.getRevenueCode(), "0519")) {
            BigDecimal payment;
            if (BigDecimalUtils.isGreaterThan(calculationContext.getPpsRate(), fqhcPricerContext.getClaimData().getMedicareAdvantagePlanAmount())) {
                payment = calculationContext.getPpsRate().subtract(fqhcPricerContext.getClaimData().getMedicareAdvantagePlanAmount());
                serviceLinePayment.setReturnCodeData(ReturnCode.LINE_SUP_MA_PAY_APPLIED_06.toReturnCodeData());
            } else {
                payment = BigDecimalUtils.ZERO;
                serviceLinePayment.setReturnCodeData(ReturnCode.LINE_SUP_MA_PAY_NOT_APPLIED_07.toReturnCodeData());
            }
            serviceLinePayment.setPayment(payment);
            calculationContext.setUnreducedPayment(payment);
        }
    }
}

