/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.fqhc.core.rules.validation;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.LocalDateUtils;
import gov.cms.fiss.pricers.fqhc.api.v2.IoceServiceLineData;
import gov.cms.fiss.pricers.fqhc.api.v2.ServiceLinePaymentData;
import gov.cms.fiss.pricers.fqhc.core.FqhcPricerContext;
import gov.cms.fiss.pricers.fqhc.core.ReturnCode;
import gov.cms.fiss.pricers.fqhc.core.ServiceLineContext;
import org.apache.commons.lang3.StringUtils;

public class ValidateGftf
implements CalculationRule<IoceServiceLineData, ServiceLinePaymentData, ServiceLineContext> {
    @Override
    public void calculate(ServiceLineContext calculationContext) {
        IoceServiceLineData ioceServiceLine = (IoceServiceLineData)calculationContext.getInput();
        if (StringUtils.equals(ioceServiceLine.getPaymentIndicator(), "14")) {
            FqhcPricerContext fqhcPricerContext = calculationContext.getFqhcPricerContext();
            fqhcPricerContext.setGftfClaim();
            if (LocalDateUtils.isBefore(fqhcPricerContext.getClaimData().getServiceFromDate(), fqhcPricerContext.getGftfStartDate())) {
                fqhcPricerContext.applyClaimReturnCode(ReturnCode.CLAIM_INVALID_SERVICE_DATE_02);
                fqhcPricerContext.setCalculationCompleted();
                calculationContext.setCalculationCompleted();
            }
        }
    }
}

