/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.fqhc.core.rules.validation;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.fqhc.api.v2.IoceServiceLineData;
import gov.cms.fiss.pricers.fqhc.api.v2.ServiceLinePaymentData;
import gov.cms.fiss.pricers.fqhc.core.FqhcPricerContext;
import gov.cms.fiss.pricers.fqhc.core.ReturnCode;
import gov.cms.fiss.pricers.fqhc.core.ServiceLineContext;
import org.apache.commons.lang3.StringUtils;

public class ValidateMedicareAdvantageStatus
implements CalculationRule<IoceServiceLineData, ServiceLinePaymentData, ServiceLineContext> {
    @Override
    public void calculate(ServiceLineContext calculationContext) {
        FqhcPricerContext fqhcPricerContext = calculationContext.getFqhcPricerContext();
        IoceServiceLineData ioceServiceLine = (IoceServiceLineData)calculationContext.getInput();
        if (StringUtils.equals(ioceServiceLine.getRevenueCode(), "0519")) {
            if (BigDecimalUtils.isGreaterThanZero(fqhcPricerContext.getClaimData().getMedicareAdvantagePlanAmount())) {
                fqhcPricerContext.setMaClaim();
            } else {
                calculationContext.applyReturnCode(ReturnCode.LINE_MA_PLAN_AMT_EQUALS_ZERO_17);
                calculationContext.setCalculationCompleted();
            }
        }
    }
}

