/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.fqhc.core.rules.validation.rates;

import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.LocalDateUtils;
import gov.cms.fiss.pricers.fqhc.api.v2.IoceServiceLineData;
import gov.cms.fiss.pricers.fqhc.api.v2.ServiceLinePaymentData;
import gov.cms.fiss.pricers.fqhc.core.FqhcPricerContext;
import gov.cms.fiss.pricers.fqhc.core.ReturnCode;
import gov.cms.fiss.pricers.fqhc.core.ServiceLineContext;
import gov.cms.fiss.pricers.fqhc.core.daily.DailyRates;
import gov.cms.fiss.pricers.fqhc.core.tables.DataTables;
import gov.cms.fiss.pricers.fqhc.core.tables.GAFRateTableEntry;
import java.math.BigDecimal;

public class DetermineDayRates
implements CalculationRule<IoceServiceLineData, ServiceLinePaymentData, ServiceLineContext> {
    @Override
    public void calculate(ServiceLineContext calculationContext) {
        IoceServiceLineData ioceServiceLine = (IoceServiceLineData)calculationContext.getInput();
        FqhcPricerContext fqhcPricerContext = calculationContext.getFqhcPricerContext();
        DataTables dataTables = calculationContext.getDataTables();
        @FixedValue BigDecimal dailyBaseRate = fqhcPricerContext.isGftfClaim() ? dataTables.getTribalRate(ioceServiceLine.getDateOfService()) : dataTables.getBaseRate(ioceServiceLine.getDateOfService());
        if (dailyBaseRate == null || dailyBaseRate.compareTo(BigDecimal.ZERO) == 0) {
            calculationContext.completeWithReturnCode(ReturnCode.LINE_NO_EFF_BASE_RATE_18);
            return;
        }
        @FixedValue BigDecimal dailyAddRate = fqhcPricerContext.isGftfClaim() ? BigDecimal.ONE : dataTables.getAddOnRate(ioceServiceLine.getDateOfService());
        if (dailyAddRate == null || dailyAddRate.compareTo(BigDecimal.ZERO) == 0) {
            calculationContext.completeWithReturnCode(ReturnCode.LINE_NO_EFF_ADD_ON_RATE_20);
            return;
        }
        @FixedValue BigDecimal dailyGafRate = fqhcPricerContext.isGftfClaim() ? BigDecimal.ONE : dataTables.getGafRate(new GAFRateTableEntry.GAFRateKey(fqhcPricerContext.getClaimData().getCarrierCode() + fqhcPricerContext.getClaimData().getLocalityCode(), ioceServiceLine.getDateOfService()));
        if (dailyGafRate == null || dailyGafRate.compareTo(BigDecimal.ZERO) == 0) {
            calculationContext.completeWithReturnCode(ReturnCode.LINE_NO_EFF_GAF_19);
            return;
        }
        BigDecimal dailyIopRateLte3 = BigDecimal.ZERO;
        if (LocalDateUtils.isAfterOrEqual(fqhcPricerContext.getClaimData().getServiceFromDate(), calculationContext.getFqhcPricerContext().getIopStartDate()) && ((dailyIopRateLte3 = fqhcPricerContext.isGftfClaim() ? dataTables.getTribalRate(ioceServiceLine.getDateOfService()) : dataTables.getIopRateLte3(ioceServiceLine.getDateOfService())) == null || dailyIopRateLte3.compareTo(BigDecimal.ZERO) == 0)) {
            calculationContext.completeWithReturnCode(ReturnCode.LINE_NO_EFF_BASE_RATE_18);
            return;
        }
        BigDecimal dailyIopRateGte4 = BigDecimal.ZERO;
        if (LocalDateUtils.isAfterOrEqual(fqhcPricerContext.getClaimData().getServiceFromDate(), calculationContext.getFqhcPricerContext().getIopSplitStartDate()) && ((dailyIopRateGte4 = fqhcPricerContext.isGftfClaim() ? dataTables.getTribalRate(ioceServiceLine.getDateOfService()) : dataTables.getIopRateGte4(ioceServiceLine.getDateOfService())) == null || dailyIopRateGte4.compareTo(BigDecimal.ZERO) == 0)) {
            calculationContext.completeWithReturnCode(ReturnCode.LINE_NO_EFF_BASE_RATE_18);
            return;
        }
        calculationContext.setDailyRates(new DailyRates(dailyBaseRate, dailyAddRate, dailyIopRateLte3, dailyIopRateGte4, dailyGafRate));
    }
}

