/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.fqhc.core.tables;

import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.fqhc.FqhcPricerConfiguration;
import gov.cms.fiss.pricers.fqhc.core.tables.AddOnRateTableEntryLookupGenerator;
import gov.cms.fiss.pricers.fqhc.core.tables.GAFRateTableEntry;
import gov.cms.fiss.pricers.fqhc.core.tables.GAFRateTableEntryLookupGenerator;
import gov.cms.fiss.pricers.fqhc.core.tables.IopPaymentRateGte4TableEntryLookupGenerator;
import gov.cms.fiss.pricers.fqhc.core.tables.IopPaymentRateLte3TableEntryLookupGenerator;
import gov.cms.fiss.pricers.fqhc.core.tables.PaymentRateTableEntryLookupGenerator;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;

public class DataTables {
    private final NavigableMap<LocalDate, BigDecimal> addOnRateTable;
    private final NavigableMap<LocalDate, BigDecimal> baseRateTable;
    private final NavigableMap<LocalDate, BigDecimal> iopRateGte4Table;
    private final NavigableMap<LocalDate, BigDecimal> iopRateLte3Table;
    private final Map<String, NavigableMap<LocalDate, BigDecimal>> gafRateTable;
    private final NavigableMap<LocalDate, BigDecimal> tribalRateTable;

    public DataTables(NavigableMap<LocalDate, BigDecimal> addOnRateTable, NavigableMap<LocalDate, BigDecimal> baseRateTable, NavigableMap<LocalDate, BigDecimal> iopRateGte4Table, NavigableMap<LocalDate, BigDecimal> iopRateLte3Table, Map<String, NavigableMap<LocalDate, BigDecimal>> gafRateTable, NavigableMap<LocalDate, BigDecimal> tribalRateTable) {
        this.addOnRateTable = addOnRateTable;
        this.baseRateTable = baseRateTable;
        this.iopRateGte4Table = iopRateGte4Table;
        this.iopRateLte3Table = iopRateLte3Table;
        this.gafRateTable = gafRateTable;
        this.tribalRateTable = tribalRateTable;
    }

    public static Map<Integer, DataTables> loadDataTables(FqhcPricerConfiguration pricerConfiguration) {
        CsvIngestionConfiguration csvIngestionConfiguration = pricerConfiguration.getCsvIngestionConfiguration();
        HashMap<Integer, DataTables> yearMap = new HashMap<Integer, DataTables>();
        NavigableMap<LocalDate, BigDecimal> addOnRateTable = new AddOnRateTableEntryLookupGenerator(csvIngestionConfiguration).generate();
        NavigableMap<LocalDate, BigDecimal> baseRateTable = new PaymentRateTableEntryLookupGenerator(csvIngestionConfiguration).generate("/base.csv");
        NavigableMap<LocalDate, BigDecimal> iopRateGte4Table = new IopPaymentRateGte4TableEntryLookupGenerator(csvIngestionConfiguration).generate("/iopRateGte4.csv");
        NavigableMap<LocalDate, BigDecimal> iopRateLte3Table = new IopPaymentRateLte3TableEntryLookupGenerator(csvIngestionConfiguration).generate("/iopRateLte3.csv");
        NavigableMap<LocalDate, BigDecimal> tribalRateTable = new PaymentRateTableEntryLookupGenerator(csvIngestionConfiguration).generate("/tribal.csv");
        for (int fiscalYear : pricerConfiguration.getSupportedYears()) {
            yearMap.put(fiscalYear, new DataTables(addOnRateTable, baseRateTable, iopRateGte4Table, iopRateLte3Table, new GAFRateTableEntryLookupGenerator(csvIngestionConfiguration).generate(fiscalYear), tribalRateTable));
        }
        return yearMap;
    }

    public BigDecimal getAddOnRate(LocalDate effectiveDate) {
        return this.getRate(effectiveDate, this.addOnRateTable);
    }

    public BigDecimal getBaseRate(LocalDate effectiveDate) {
        return this.getRate(effectiveDate, this.baseRateTable);
    }

    public BigDecimal getIopRateGte4(LocalDate effectiveDate) {
        return this.getRate(effectiveDate, this.iopRateGte4Table);
    }

    public BigDecimal getIopRateLte3(LocalDate effectiveDate) {
        return this.getRate(effectiveDate, this.iopRateLte3Table);
    }

    public BigDecimal getGafRate(GAFRateTableEntry.GAFRateKey key) {
        NavigableMap<LocalDate, BigDecimal> providerRates = this.gafRateTable.get(key.getCarrierLocality());
        if (providerRates == null) {
            return null;
        }
        return this.getRate(key.getServiceDate(), providerRates);
    }

    public BigDecimal getTribalRate(LocalDate effectiveDate) {
        return this.getRate(effectiveDate, this.tribalRateTable);
    }

    private BigDecimal getRate(LocalDate effectiveDate, NavigableMap<LocalDate, BigDecimal> map) {
        Map.Entry<LocalDate, BigDecimal> floorEntry = map.floorEntry(effectiveDate);
        if (floorEntry == null) {
            return null;
        }
        return floorEntry.getValue();
    }
}

