/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.connectionpool;

import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.connectionpool.Link;
import org.glassfish.grizzly.connectionpool.SingleEndpointPool;

public final class ConnectionInfo<E> {
    final Connection connection;
    final Link<ConnectionInfo<E>> readyStateLink;
    final SingleEndpointPool<E> endpointPool;
    long ttlTimeout;
    private final long pooledTimeStamp;

    ConnectionInfo(Connection connection, SingleEndpointPool<E> endpointPool) {
        this.connection = connection;
        this.endpointPool = endpointPool;
        this.readyStateLink = new Link<ConnectionInfo>(this);
        this.pooledTimeStamp = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReady() {
        Object object = this.endpointPool.poolSync;
        synchronized (object) {
            return this.readyStateLink.isAttached();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getReadyTimeStamp() {
        Object object = this.endpointPool.poolSync;
        synchronized (object) {
            return this.readyStateLink.getAttachmentTimeStamp();
        }
    }

    public long getPooledTimeStamp() {
        return this.pooledTimeStamp;
    }

    public String toString() {
        return "ConnectionInfo{connection=" + this.connection + ", readyStateLink=" + this.readyStateLink + ", endpointPool=" + this.endpointPool + ", pooledTimeStamp=" + this.pooledTimeStamp + "} " + super.toString();
    }
}

