/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.glassfish.grizzly.http.util.HttpCodecUtils;
import org.glassfish.grizzly.utils.Charsets;

public final class FastHttpDateFormat {
    private static final String ASCII_CHARSET_NAME = Charsets.ASCII_CHARSET.name();
    private static final int CACHE_SIZE = 1000;
    private static final TimeZone GMT_TIME_ZONE = TimeZone.getTimeZone("GMT");
    private static final SimpleDateFormatter FORMATTER = new SimpleDateFormatter();
    private static final ThreadLocal<SimpleDateFormatter> FORMAT = new ThreadLocal<SimpleDateFormatter>(){

        @Override
        protected SimpleDateFormatter initialValue() {
            return new SimpleDateFormatter();
        }
    };
    private static final ThreadLocal FORMATS = new ThreadLocal(){

        protected Object initialValue() {
            SimpleDateFormat[] f = new SimpleDateFormat[3];
            f[0] = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
            f[0].setTimeZone(GMT_TIME_ZONE);
            f[1] = new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US);
            f[1].setTimeZone(GMT_TIME_ZONE);
            f[2] = new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US);
            f[2].setTimeZone(GMT_TIME_ZONE);
            return f;
        }
    };
    private static volatile long nextGeneration;
    private static final AtomicBoolean isGeneratingNow;
    private static final StringBuffer currentDateBuffer;
    private static byte[] currentDateBytes;
    private static String cachedStringDate;
    private static volatile byte[] dateBytesForCachedStringDate;
    private static final ConcurrentMap<Long, String> formatCache;
    private static final ConcurrentMap<String, Long> parseCache;

    public static String getCurrentDate() {
        byte[] currentDateBytesNow = FastHttpDateFormat.getCurrentDateBytes();
        if (currentDateBytesNow != dateBytesForCachedStringDate) {
            try {
                cachedStringDate = new String(currentDateBytesNow, ASCII_CHARSET_NAME);
                dateBytesForCachedStringDate = currentDateBytesNow;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return cachedStringDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getCurrentDateBytes() {
        long now = System.currentTimeMillis();
        long diff = now - nextGeneration;
        if (diff > 0L && (diff > 5000L || !isGeneratingNow.get() && isGeneratingNow.compareAndSet(false, true))) {
            ThreadLocal<SimpleDateFormatter> threadLocal = FORMAT;
            synchronized (threadLocal) {
                if (now > nextGeneration) {
                    currentDateBuffer.setLength(0);
                    FORMATTER.formatTo(now, currentDateBuffer);
                    currentDateBytes = HttpCodecUtils.toCheckedByteArray(currentDateBuffer);
                    nextGeneration = now + 1000L;
                }
                isGeneratingNow.set(false);
            }
        }
        return currentDateBytes;
    }

    public static String formatDate(long value, DateFormat threadLocalFormat) {
        Long longValue = value = value / 1000L * 1000L;
        String cachedDate = (String)formatCache.get(longValue);
        if (cachedDate != null) {
            return cachedDate;
        }
        String newDate = threadLocalFormat != null ? threadLocalFormat.format(value) : FORMAT.get().format(value);
        FastHttpDateFormat.updateFormatCache(longValue, newDate);
        return newDate;
    }

    public static long parseDate(String value, DateFormat[] threadLocalformats) {
        Long cachedDate = (Long)parseCache.get(value);
        if (cachedDate != null) {
            return cachedDate;
        }
        long date = threadLocalformats != null ? FastHttpDateFormat.internalParseDate(value, threadLocalformats) : FastHttpDateFormat.internalParseDate(value, (SimpleDateFormat[])FORMATS.get());
        if (date != -1L) {
            FastHttpDateFormat.updateParseCache(value, date);
        }
        return date;
    }

    private static long internalParseDate(String value, DateFormat[] formats) {
        for (int i2 = 0; i2 < formats.length; ++i2) {
            try {
                return formats[i2].parse(value).getTime();
            }
            catch (ParseException parseException) {
                continue;
            }
        }
        return -1L;
    }

    private static void updateFormatCache(Long key, String value) {
        if (value == null) {
            return;
        }
        if (formatCache.size() > 1000) {
            formatCache.clear();
        }
        formatCache.put(key, value);
    }

    private static void updateParseCache(String key, Long value) {
        if (parseCache.size() > 1000) {
            parseCache.clear();
        }
        parseCache.put(key, value);
    }

    static {
        isGeneratingNow = new AtomicBoolean();
        currentDateBuffer = new StringBuffer();
        formatCache = new ConcurrentHashMap<Long, String>(1000, 0.75f, 64);
        parseCache = new ConcurrentHashMap<String, Long>(1000, 0.75f, 64);
    }

    private static final class SimpleDateFormatter {
        private final Date date;
        private final SimpleDateFormat f;
        private final FieldPosition pos = new FieldPosition(-1);

        public SimpleDateFormatter() {
            this.date = new Date();
            this.f = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
            this.f.setTimeZone(GMT_TIME_ZONE);
        }

        public final String format(long timeMillis) {
            this.date.setTime(timeMillis);
            return this.f.format(this.date);
        }

        public final StringBuffer formatTo(long timeMillis, StringBuffer buffer) {
            this.date.setTime(timeMillis);
            return this.f.format(this.date, buffer, this.pos);
        }
    }
}

