/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jakarta.rs.cfg;

import com.fasterxml.jackson.databind.cfg.ConfigFeature;

public enum JakartaRSFeature implements ConfigFeature
{
    ALLOW_EMPTY_INPUT(true),
    READ_FULL_STREAM(true),
    ADD_NO_SNIFF_HEADER(false),
    DYNAMIC_OBJECT_MAPPER_LOOKUP(false),
    CACHE_ENDPOINT_READERS(true),
    CACHE_ENDPOINT_WRITERS(true);

    private final boolean _defaultState;

    private JakartaRSFeature(boolean defaultState) {
        this._defaultState = defaultState;
    }

    public static int collectDefaults() {
        int flags = 0;
        for (JakartaRSFeature f : JakartaRSFeature.values()) {
            if (!f.enabledByDefault()) continue;
            flags |= f.getMask();
        }
        return flags;
    }

    @Override
    public boolean enabledByDefault() {
        return this._defaultState;
    }

    @Override
    public int getMask() {
        return 1 << this.ordinal();
    }

    @Override
    public boolean enabledIn(int flags) {
        return (flags & this.getMask()) != 0;
    }
}

