/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.AsyncCacheLoader;
import com.github.benmanes.caffeine.cache.BoundedLocalCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jspecify.annotations.Nullable;

interface LocalCacheFactory {
    public static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    public static final MethodType FACTORY = MethodType.methodType(Void.TYPE, Caffeine.class, AsyncCacheLoader.class, Boolean.TYPE);
    public static final MethodType FACTORY_CALL = FACTORY.changeReturnType(BoundedLocalCache.class);
    public static final ConcurrentMap<String, LocalCacheFactory> FACTORIES = new ConcurrentHashMap<String, LocalCacheFactory>();

    public <K, V> BoundedLocalCache<K, V> newInstance(Caffeine<K, V> var1, @Nullable AsyncCacheLoader<? super K, V> var2, boolean var3) throws Throwable;

    public static <K, V> BoundedLocalCache<K, V> newBoundedLocalCache(Caffeine<K, V> builder, @Nullable AsyncCacheLoader<? super K, V> cacheLoader, boolean isAsync) {
        String className = LocalCacheFactory.getClassName(builder);
        LocalCacheFactory factory = LocalCacheFactory.loadFactory(className);
        try {
            return factory.newInstance(builder, cacheLoader, isAsync);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable t2) {
            throw new IllegalStateException(className, t2);
        }
    }

    public static String getClassName(Caffeine<?, ?> builder) {
        StringBuilder className = new StringBuilder();
        if (builder.isStrongKeys()) {
            className.append('S');
        } else {
            className.append('W');
        }
        if (builder.isStrongValues()) {
            className.append('S');
        } else {
            className.append('I');
        }
        if (builder.removalListener != null) {
            className.append('L');
        }
        if (builder.isRecordingStats()) {
            className.append('S');
        }
        if (builder.evicts()) {
            className.append('M');
            if (builder.isWeighted()) {
                className.append('W');
            } else {
                className.append('S');
            }
        }
        if (builder.expiresAfterAccess() || builder.expiresVariable()) {
            className.append('A');
        }
        if (builder.expiresAfterWrite()) {
            className.append('W');
        }
        if (builder.refreshAfterWrite()) {
            className.append('R');
        }
        return className.toString();
    }

    public static LocalCacheFactory loadFactory(String className) {
        LocalCacheFactory factory = (LocalCacheFactory)FACTORIES.get(className);
        if (factory == null) {
            factory = FACTORIES.computeIfAbsent(className, LocalCacheFactory::newFactory);
        }
        return factory;
    }

    public static LocalCacheFactory newFactory(String className) {
        try {
            Class<?> clazz = LOOKUP.findClass(LocalCacheFactory.class.getPackageName() + "." + className);
            try {
                return LOOKUP.findStaticVarHandle(clazz, "FACTORY", LocalCacheFactory.class).get();
            }
            catch (NoSuchFieldException e) {
                return new MethodHandleBasedFactory(clazz);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException t2) {
            throw new IllegalStateException(className, t2);
        }
    }

    public static final class MethodHandleBasedFactory
    implements LocalCacheFactory {
        final MethodHandle methodHandle;

        MethodHandleBasedFactory(Class<?> clazz) throws NoSuchMethodException, IllegalAccessException {
            this.methodHandle = LOOKUP.findConstructor(clazz, FACTORY).asType(FACTORY_CALL);
        }

        @Override
        public <K, V> BoundedLocalCache<K, V> newInstance(Caffeine<K, V> builder, @Nullable AsyncCacheLoader<? super K, V> cacheLoader, boolean async) throws Throwable {
            return this.methodHandle.invokeExact(builder, cacheLoader, async);
        }
    }
}

