/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.api.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.NumberDeserializers;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScaleInfo;
import java.io.IOException;
import java.math.BigDecimal;

public class ScaledBigDecimalDeserializer
extends StdScalarDeserializer<BigDecimal>
implements ContextualDeserializer {
    private final NumberDeserializers.BigDecimalDeserializer deserializer;
    private BigDecimalScaleInfo scaleInfo;

    public ScaledBigDecimalDeserializer(NumberDeserializers.BigDecimalDeserializer deserializer) {
        super(BigDecimal.class);
        this.deserializer = deserializer;
    }

    private ScaledBigDecimalDeserializer(NumberDeserializers.BigDecimalDeserializer deserializer, BigDecimalScaleInfo scaleInfo) {
        this(deserializer);
        this.scaleInfo = scaleInfo;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext context, BeanProperty property) {
        BigDecimalScale annotation = property.getMember().getAnnotation(BigDecimalScale.class);
        if (annotation == null) {
            return this.deserializer;
        }
        return new ScaledBigDecimalDeserializer(this.deserializer, new BigDecimalScaleInfo(annotation.scale(), annotation.roundingMode()));
    }

    @Override
    public BigDecimal deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        BigDecimal value = this.deserializer.deserialize(parser, context);
        if (value != null && value.scale() < this.scaleInfo.getScale()) {
            return value.setScale(this.scaleInfo.getScale(), this.scaleInfo.getRoundingMode());
        }
        return value;
    }
}

