/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.application;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.fasterxml.jackson.databind.cfg.CoercionInputShape;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.module.blackbird.BlackbirdModule;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScaleModule;
import gov.cms.fiss.pricers.common.application.MergingConfigurationSourceProvider;
import gov.cms.fiss.pricers.common.application.OpenApiApplicationConfiguration;
import gov.cms.fiss.pricers.common.application.contract.OpenApiContractBundle;
import gov.cms.fiss.pricers.common.application.contract.OpenApiCustomizer;
import gov.cms.fiss.pricers.common.application.errors.ClientErrorExceptionMapper;
import gov.cms.fiss.pricers.common.application.errors.DateValidationExceptionMapper;
import gov.cms.fiss.pricers.common.application.errors.InputValidationExceptionMapper;
import gov.cms.fiss.pricers.common.application.errors.JsonMappingExceptionMapper;
import gov.cms.fiss.pricers.common.application.errors.JsonParseExceptionMapper;
import gov.cms.fiss.pricers.common.application.errors.PathParamExceptionMapper;
import gov.cms.fiss.pricers.common.application.errors.QueryParamExceptionMapper;
import gov.cms.fiss.pricers.common.application.errors.UncategorizedParamExceptionMapper;
import gov.cms.fiss.pricers.common.application.errors.UnknownExceptionMapper;
import gov.cms.fiss.pricers.common.application.errors.WebApplicationExceptionMapper;
import gov.cms.fiss.pricers.common.application.errors.YearNotImplementedExceptionMapper;
import gov.cms.fiss.pricers.common.application.filters.CacheControlFilter;
import gov.cms.fiss.pricers.common.application.filters.ContentLengthFilter;
import gov.cms.fiss.pricers.common.application.filters.ContentLengthFilterConfiguration;
import gov.cms.fiss.pricers.common.application.filters.FilterConfiguration;
import gov.cms.fiss.pricers.common.application.filters.HeaderFilterConfiguration;
import gov.cms.fiss.pricers.common.application.filters.LogFilterConfiguration;
import gov.cms.fiss.pricers.common.application.filters.PricerRequestLogFilter;
import gov.cms.fiss.pricers.common.application.filters.PricerResponseLogFilter;
import gov.cms.fiss.pricers.common.application.filters.RequestContextCaptureFilter;
import gov.cms.fiss.pricers.common.application.info.ApplicationInfoBundle;
import gov.cms.fiss.pricers.common.application.resources.DefaultPricerHealthCheck;
import gov.cms.fiss.pricers.common.application.resources.DefaultPricerHealthResource;
import gov.cms.fiss.pricers.common.application.resources.SupportedYearResource;
import io.dropwizard.configuration.EnvironmentVariableSubstitutor;
import io.dropwizard.configuration.ResourceConfigurationSourceProvider;
import io.dropwizard.configuration.SubstitutingSourceProvider;
import io.dropwizard.core.Application;
import io.dropwizard.core.setup.Bootstrap;
import io.dropwizard.core.setup.Environment;
import io.dropwizard.jersey.jackson.JsonProcessingExceptionMapper;
import io.dropwizard.web.WebBundle;
import io.dropwizard.web.conf.WebConfiguration;
import jakarta.servlet.FilterRegistration;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.problem.jackson.ProblemModule;
import org.zalando.problem.violations.ConstraintViolationProblemModule;

public abstract class OpenApiPricerApplication<C extends OpenApiApplicationConfiguration>
extends Application<C> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenApiPricerApplication.class);

    protected abstract void configureApplication(C var1, Environment var2);

    protected void customizeJacksonMapper(ObjectMapper objectMapper) {
        objectMapper.registerModule(new BlackbirdModule()).registerModule(new BigDecimalScaleModule()).registerModule(new ProblemModule()).registerModule(new ConstraintViolationProblemModule()).disable(DeserializationFeature.ACCEPT_FLOAT_AS_INT).enable(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN).enable(JsonGenerator.Feature.IGNORE_UNKNOWN).setDefaultSetterInfo(JsonSetter.Value.forValueNulls(Nulls.SKIP)).setSerializationInclusion(JsonInclude.Include.NON_NULL).setNodeFactory(JsonNodeFactory.withExactBigDecimals(true));
        objectMapper.setConfig((DeserializationConfig)objectMapper.getDeserializationConfig().without(new MapperFeature[]{MapperFeature.ALLOW_COERCION_OF_SCALARS}));
        objectMapper.setConfig((SerializationConfig)objectMapper.getSerializationConfig().without(new MapperFeature[]{MapperFeature.ALLOW_COERCION_OF_SCALARS}));
        objectMapper.coercionConfigFor(LogicalType.Integer).setCoercion(CoercionInputShape.EmptyString, CoercionAction.AsNull).setCoercion(CoercionInputShape.String, CoercionAction.TryConvert).setAcceptBlankAsEmpty(true);
        objectMapper.coercionConfigFor(LogicalType.Float).setCoercion(CoercionInputShape.EmptyString, CoercionAction.AsNull).setCoercion(CoercionInputShape.String, CoercionAction.TryConvert).setAcceptBlankAsEmpty(true);
        objectMapper.coercionConfigFor(LogicalType.Boolean).setCoercion(CoercionInputShape.EmptyString, CoercionAction.Fail).setCoercion(CoercionInputShape.String, CoercionAction.TryConvert);
    }

    protected List<OpenApiCustomizer> getContractCustomizers() {
        return Collections.singletonList(OpenApiContractBundle.DEFAULT_LOCAL_SERVER_CUSTOMIZER);
    }

    protected abstract List<Package> getResourcePackages();

    protected Map<Integer, String> getCalculationVersions() {
        return new HashMap<Integer, String>();
    }

    @Override
    public void initialize(Bootstrap<C> bootstrap) {
        bootstrap.setConfigurationSourceProvider(new MergingConfigurationSourceProvider(new ResourceConfigurationSourceProvider(), "/default-configuration.yaml", new SubstitutingSourceProvider(new ResourceConfigurationSourceProvider(), new EnvironmentVariableSubstitutor(true)), new YAMLFactory(), bootstrap.getObjectMapper()));
        ArrayList<Package> resourcePackages = new ArrayList<Package>(this.getResourcePackages());
        resourcePackages.add(DefaultPricerHealthResource.class.getPackage());
        bootstrap.addBundle(new OpenApiContractBundle(resourcePackages, this.getContractCustomizers()));
        bootstrap.addBundle(new ApplicationInfoBundle(this.getCalculationVersions()));
        bootstrap.addBundle(new WebBundle<C>(){

            @Override
            public WebConfiguration getWebConfiguration(C configuration) {
                return ((OpenApiApplicationConfiguration)configuration).getWebConfiguration();
            }
        });
        this.customizeJacksonMapper(bootstrap.getObjectMapper());
    }

    @Override
    public void run(C configuration, Environment environment) {
        LOGGER.info("start: {} {}, jvm {}, os {} {} {}, pid {}, user {}", this.getName(), this.getClass().getPackage().getImplementationVersion(), System.getProperty("java.runtime.version", System.getProperty("java.version")), System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"), ProcessHandle.current().pid(), System.getProperty("user.name"));
        this.configureApplication(configuration, environment);
        environment.healthChecks().register("default", new DefaultPricerHealthCheck());
        DefaultPricerHealthResource healthResource = new DefaultPricerHealthResource(environment.healthChecks());
        environment.jersey().register(healthResource);
        this.confirmSandbox();
        FilterConfiguration filterConfiguration = ((OpenApiApplicationConfiguration)configuration).getFilterConfiguration();
        this.enableContentLengthFilter(environment, filterConfiguration.getContentLengthFilterConfiguration());
        this.enableAdditionalHeaderFilters(environment, filterConfiguration.getHeaderFilterConfiguration());
        this.enableLogFiltering(environment, filterConfiguration.getLogFilterConfiguration(), filterConfiguration.getContentLengthFilterConfiguration());
        environment.jersey().register(new SupportedYearResource((OpenApiApplicationConfiguration)configuration));
        environment.jersey().register(new JsonProcessingExceptionMapper(true));
        environment.jersey().register(new JsonParseExceptionMapper());
        environment.jersey().register(new JsonMappingExceptionMapper());
        environment.jersey().register(new InputValidationExceptionMapper());
        environment.jersey().register(new YearNotImplementedExceptionMapper());
        environment.jersey().register(new DateValidationExceptionMapper());
        environment.jersey().register(new PathParamExceptionMapper());
        environment.jersey().register(new QueryParamExceptionMapper());
        environment.jersey().register(new UncategorizedParamExceptionMapper());
        environment.jersey().register(new ClientErrorExceptionMapper());
        environment.jersey().register(new UnknownExceptionMapper());
        environment.jersey().register(new RequestContextCaptureFilter());
        environment.jersey().register(new WebApplicationExceptionMapper());
    }

    private void enableContentLengthFilter(Environment environment, ContentLengthFilterConfiguration filterConfiguration) {
        FilterRegistration.Dynamic contentLengthFilter = environment.servlets().addFilter("ContentLengthFilter", ContentLengthFilter.class);
        contentLengthFilter.setInitParameter("maximumRequestSize", Integer.toString(filterConfiguration.getMaximumRequestSize()));
        contentLengthFilter.addMappingForUrlPatterns(null, false, "/*");
    }

    private void enableAdditionalHeaderFilters(Environment environment, HeaderFilterConfiguration filterConfiguration) {
        if (filterConfiguration.isEnabled()) {
            environment.jersey().register(new CacheControlFilter());
        }
    }

    protected void enableLogFiltering(Environment environment, LogFilterConfiguration logFilterConfiguration, ContentLengthFilterConfiguration contentLengthFilterConfiguration) {
        if (logFilterConfiguration.isEnabled()) {
            environment.jersey().register(new PricerRequestLogFilter(environment.getObjectMapper(), logFilterConfiguration, contentLengthFilterConfiguration));
            environment.jersey().register(new PricerResponseLogFilter(environment.getObjectMapper(), logFilterConfiguration));
        }
    }

    private void confirmSandbox() {
        SecurityManager manager = System.getSecurityManager();
        if (manager == null) {
            LOGGER.error("security manager is not enabled: use -Djava.security.manager");
            return;
        }
        LOGGER.info("security manager {}", (Object)manager);
        try {
            Files.readAllBytes(Path.of("/", new String[0]));
        }
        catch (AccessControlException e) {
            LOGGER.info("Confirmed that sandbox is active");
            return;
        }
        catch (IOException e) {
            LOGGER.info("Unexpected exception", e);
        }
        LOGGER.error("security policy is not loaded: use -Djava.security.policy==...");
    }
}

