/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.application.errors;

import com.fasterxml.jackson.core.JsonParseException;
import gov.cms.fiss.pricers.common.application.request.RequestContentExtractor;
import io.dropwizard.jersey.errors.ErrorMessage;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.problem.Problem;
import org.zalando.problem.Status;

@Provider
public class JsonParseExceptionMapper
implements ExceptionMapper<JsonParseException> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonParseExceptionMapper.class);
    public static final String ERROR_MESSAGE = "Unable to process JSON";

    @Override
    public Response toResponse(JsonParseException exception) {
        if (null == RequestContentExtractor.rfc7807Support()) {
            ErrorMessage errorMessage = new ErrorMessage(Status.BAD_REQUEST.getStatusCode(), ERROR_MESSAGE, exception.getOriginalMessage());
            return Response.status(errorMessage.getCode()).type(MediaType.APPLICATION_JSON_TYPE).entity(errorMessage).build();
        }
        return Response.status(Status.BAD_REQUEST.getStatusCode()).type("application/problem+json").entity(Problem.builder().withTitle(ERROR_MESSAGE).withDetail(exception.getOriginalMessage()).withStatus(Status.BAD_REQUEST).build()).build();
    }
}

