/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.fqhc.api.v2;

import gov.cms.fiss.pricers.common.api.ClaimData;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.serialization.StrictLocalDate;
import gov.cms.fiss.pricers.fqhc.api.v2.IoceServiceLineData;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;

@Schema(description="The FQHC claim data to process for pricing.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="I-CLAIM-LEVEL-INPUT", value="<structure>)")})})
public class FqhcClaimData
extends ClaimData {
    @NotNull
    @Pattern(regexp="\\d{5}", message="must be five digits")
    @Schema(description="The carrier's code.", example="02102", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="I-CARRIER", value="PIC X(05)")})})
    private @NotNull @Pattern(regexp="\\d{5}", message="must be five digits") String carrierCode;
    @ArraySchema(arraySchema=@Schema(description="The demo codes related to the claim.", example="[ \"83\", \"66\", \"29\", \"15\" ]"), uniqueItems=true)
    @Size(max=4, min=1)
    private @Size(max=4, min=1) List<@Pattern(regexp="[A-Z\\d]{2}", message="must be two alphanumeric characters") String> demoCodes;
    @ArraySchema(arraySchema=@Schema(description="The services provided."), extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="I-SERVICE-LINE", value="<structure>")})}, uniqueItems=true)
    @NotEmpty
    @Size(max=450)
    @Valid
    private @NotEmpty @Size(max=450) @Valid List<@NotNull IoceServiceLineData> ioceServiceLines;
    @NotNull
    @Pattern(regexp="\\d{2}", message="must be two digits")
    @Schema(description="The locality's code.", example="01", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="I-LOCALITY", value="PIC X(02)")})})
    private @NotNull @Pattern(regexp="\\d{2}", message="must be two digits") String localityCode;
    @BigDecimalScale
    @DecimalMax(value="1.00")
    @DecimalMin(value="0")
    @Digits(integer=1, fraction=2)
    @Schema(description="The Maryland Primary-Care Program (MDPCP) reduction percent.", example="0.25")
    private @DecimalMax(value="1.00") @DecimalMin(value="0") @Digits(integer=1, fraction=2) BigDecimal mdpcpReductionPercent;
    @BigDecimalScale
    @DecimalMax(value="999999999.99")
    @DecimalMin(value="0")
    @Digits(integer=9, fraction=2)
    @NotNull
    @Schema(description="The Medicare Advantage plan amount.", example="150.99", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="I-MA-PLAN-AMT", value="PIC 9(09)V99")})})
    private @DecimalMax(value="999999999.99") @DecimalMin(value="0") @Digits(integer=9, fraction=2) @NotNull BigDecimal medicareAdvantagePlanAmount;
    @NotNull
    @Schema(description="The start date of service.", example="2020-05-13", format="yyyy-MM-dd", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="I-SRVC-FROM-DATET", value="PIC 9(08)")})})
    @StrictLocalDate
    private LocalDate serviceFromDate;
    @NotNull
    @Schema(description="The end date of service.", example="2020-06-13", format="yyyy-MM-dd", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="I-SRVC-THRU-DATE", value="PIC 9(08)")})})
    @StrictLocalDate
    private LocalDate serviceThroughDate;

    @Generated
    public String getCarrierCode() {
        return this.carrierCode;
    }

    @Generated
    public List<@Pattern(regexp="[A-Z\\d]{2}", message="must be two alphanumeric characters") String> getDemoCodes() {
        return this.demoCodes;
    }

    @Generated
    public List<@NotNull IoceServiceLineData> getIoceServiceLines() {
        return this.ioceServiceLines;
    }

    @Generated
    public String getLocalityCode() {
        return this.localityCode;
    }

    @Generated
    public BigDecimal getMdpcpReductionPercent() {
        return this.mdpcpReductionPercent;
    }

    @Generated
    public BigDecimal getMedicareAdvantagePlanAmount() {
        return this.medicareAdvantagePlanAmount;
    }

    @Generated
    public LocalDate getServiceFromDate() {
        return this.serviceFromDate;
    }

    @Generated
    public LocalDate getServiceThroughDate() {
        return this.serviceThroughDate;
    }

    @Generated
    public void setCarrierCode(String carrierCode) {
        this.carrierCode = carrierCode;
    }

    @Generated
    public void setDemoCodes(List<@Pattern(regexp="[A-Z\\d]{2}", message="must be two alphanumeric characters") String> demoCodes) {
        this.demoCodes = demoCodes;
    }

    @Generated
    public void setIoceServiceLines(List<@NotNull IoceServiceLineData> ioceServiceLines) {
        this.ioceServiceLines = ioceServiceLines;
    }

    @Generated
    public void setLocalityCode(String localityCode) {
        this.localityCode = localityCode;
    }

    @Generated
    public void setMdpcpReductionPercent(BigDecimal mdpcpReductionPercent) {
        this.mdpcpReductionPercent = mdpcpReductionPercent;
    }

    @Generated
    public void setMedicareAdvantagePlanAmount(BigDecimal medicareAdvantagePlanAmount) {
        this.medicareAdvantagePlanAmount = medicareAdvantagePlanAmount;
    }

    @Generated
    public void setServiceFromDate(LocalDate serviceFromDate) {
        this.serviceFromDate = serviceFromDate;
    }

    @Generated
    public void setServiceThroughDate(LocalDate serviceThroughDate) {
        this.serviceThroughDate = serviceThroughDate;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FqhcClaimData)) {
            return false;
        }
        FqhcClaimData other = (FqhcClaimData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$carrierCode = this.getCarrierCode();
        String other$carrierCode = other.getCarrierCode();
        if (this$carrierCode == null ? other$carrierCode != null : !this$carrierCode.equals(other$carrierCode)) {
            return false;
        }
        List<String> this$demoCodes = this.getDemoCodes();
        List<String> other$demoCodes = other.getDemoCodes();
        if (this$demoCodes == null ? other$demoCodes != null : !((Object)this$demoCodes).equals(other$demoCodes)) {
            return false;
        }
        List<IoceServiceLineData> this$ioceServiceLines = this.getIoceServiceLines();
        List<IoceServiceLineData> other$ioceServiceLines = other.getIoceServiceLines();
        if (this$ioceServiceLines == null ? other$ioceServiceLines != null : !((Object)this$ioceServiceLines).equals(other$ioceServiceLines)) {
            return false;
        }
        String this$localityCode = this.getLocalityCode();
        String other$localityCode = other.getLocalityCode();
        if (this$localityCode == null ? other$localityCode != null : !this$localityCode.equals(other$localityCode)) {
            return false;
        }
        BigDecimal this$mdpcpReductionPercent = this.getMdpcpReductionPercent();
        BigDecimal other$mdpcpReductionPercent = other.getMdpcpReductionPercent();
        if (this$mdpcpReductionPercent == null ? other$mdpcpReductionPercent != null : !((Object)this$mdpcpReductionPercent).equals(other$mdpcpReductionPercent)) {
            return false;
        }
        BigDecimal this$medicareAdvantagePlanAmount = this.getMedicareAdvantagePlanAmount();
        BigDecimal other$medicareAdvantagePlanAmount = other.getMedicareAdvantagePlanAmount();
        if (this$medicareAdvantagePlanAmount == null ? other$medicareAdvantagePlanAmount != null : !((Object)this$medicareAdvantagePlanAmount).equals(other$medicareAdvantagePlanAmount)) {
            return false;
        }
        LocalDate this$serviceFromDate = this.getServiceFromDate();
        LocalDate other$serviceFromDate = other.getServiceFromDate();
        if (this$serviceFromDate == null ? other$serviceFromDate != null : !((Object)this$serviceFromDate).equals(other$serviceFromDate)) {
            return false;
        }
        LocalDate this$serviceThroughDate = this.getServiceThroughDate();
        LocalDate other$serviceThroughDate = other.getServiceThroughDate();
        return !(this$serviceThroughDate == null ? other$serviceThroughDate != null : !((Object)this$serviceThroughDate).equals(other$serviceThroughDate));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FqhcClaimData;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $carrierCode = this.getCarrierCode();
        result = result * 59 + ($carrierCode == null ? 43 : $carrierCode.hashCode());
        List<String> $demoCodes = this.getDemoCodes();
        result = result * 59 + ($demoCodes == null ? 43 : ((Object)$demoCodes).hashCode());
        List<IoceServiceLineData> $ioceServiceLines = this.getIoceServiceLines();
        result = result * 59 + ($ioceServiceLines == null ? 43 : ((Object)$ioceServiceLines).hashCode());
        String $localityCode = this.getLocalityCode();
        result = result * 59 + ($localityCode == null ? 43 : $localityCode.hashCode());
        BigDecimal $mdpcpReductionPercent = this.getMdpcpReductionPercent();
        result = result * 59 + ($mdpcpReductionPercent == null ? 43 : ((Object)$mdpcpReductionPercent).hashCode());
        BigDecimal $medicareAdvantagePlanAmount = this.getMedicareAdvantagePlanAmount();
        result = result * 59 + ($medicareAdvantagePlanAmount == null ? 43 : ((Object)$medicareAdvantagePlanAmount).hashCode());
        LocalDate $serviceFromDate = this.getServiceFromDate();
        result = result * 59 + ($serviceFromDate == null ? 43 : ((Object)$serviceFromDate).hashCode());
        LocalDate $serviceThroughDate = this.getServiceThroughDate();
        result = result * 59 + ($serviceThroughDate == null ? 43 : ((Object)$serviceThroughDate).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "FqhcClaimData(carrierCode=" + this.getCarrierCode() + ", demoCodes=" + this.getDemoCodes() + ", ioceServiceLines=" + this.getIoceServiceLines() + ", localityCode=" + this.getLocalityCode() + ", mdpcpReductionPercent=" + this.getMdpcpReductionPercent() + ", medicareAdvantagePlanAmount=" + this.getMedicareAdvantagePlanAmount() + ", serviceFromDate=" + this.getServiceFromDate() + ", serviceThroughDate=" + this.getServiceThroughDate() + ")";
    }

    @Generated
    public FqhcClaimData() {
    }
}

