/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.fqhc.api.v2;

import gov.cms.fiss.pricers.common.api.PaymentData;
import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithTwoFractionDigits;
import gov.cms.fiss.pricers.fqhc.api.v2.ServiceLinePaymentData;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import lombok.Generated;

@Schema(description="The FQHC prospective payment data.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="O-CLAIM-LEVEL-OUTPUT", value="<structure>)")})})
public class FqhcPaymentData
extends PaymentData {
    @BigDecimalScale(scale=4)
    @DecimalMin(value="0")
    @DecimalMax(value="9.9999")
    @Digits(integer=1, fraction=4)
    @NotNull
    @Schema(description="The location-based adjustment factor.", example="1.4533", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="O-GEO-ADJ-FACT", value="PIC 9(01)V9(04)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9.9999") @Digits(integer=1, fraction=4) @NotNull @FixedValue BigDecimal geographicAdjustmentFactor = BigDecimal.ZERO.setScale(4, RoundingMode.UNNECESSARY);
    @ArraySchema(arraySchema=@Schema(description="The payments related to the services provided."), extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="O-LINE-LEVEL-OUTPUT", value="<structure>")})}, uniqueItems=true)
    @NotEmpty
    @Size(max=450)
    @Valid
    private @NotEmpty @Size(max=450) @Valid List<@NotNull ServiceLinePaymentData> serviceLinePayments;
    @BigDecimalScale
    @NotNull
    @Schema(description="The total claim coinsurance amount.", example="199.99", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="O-TOT-CLM-COIN", value="PIC 9(09)V99")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal totalClaimCoinsuranceAmount = BigDecimal.ZERO.setScale(2, RoundingMode.UNNECESSARY);

    @Generated
    public BigDecimal getGeographicAdjustmentFactor() {
        return this.geographicAdjustmentFactor;
    }

    @Generated
    public List<@NotNull ServiceLinePaymentData> getServiceLinePayments() {
        return this.serviceLinePayments;
    }

    @Generated
    public BigDecimal getTotalClaimCoinsuranceAmount() {
        return this.totalClaimCoinsuranceAmount;
    }

    @Generated
    public void setGeographicAdjustmentFactor(BigDecimal geographicAdjustmentFactor) {
        this.geographicAdjustmentFactor = geographicAdjustmentFactor;
    }

    @Generated
    public void setServiceLinePayments(List<@NotNull ServiceLinePaymentData> serviceLinePayments) {
        this.serviceLinePayments = serviceLinePayments;
    }

    @Generated
    public void setTotalClaimCoinsuranceAmount(BigDecimal totalClaimCoinsuranceAmount) {
        this.totalClaimCoinsuranceAmount = totalClaimCoinsuranceAmount;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FqhcPaymentData)) {
            return false;
        }
        FqhcPaymentData other = (FqhcPaymentData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BigDecimal this$geographicAdjustmentFactor = this.getGeographicAdjustmentFactor();
        BigDecimal other$geographicAdjustmentFactor = other.getGeographicAdjustmentFactor();
        if (this$geographicAdjustmentFactor == null ? other$geographicAdjustmentFactor != null : !((Object)this$geographicAdjustmentFactor).equals(other$geographicAdjustmentFactor)) {
            return false;
        }
        List<ServiceLinePaymentData> this$serviceLinePayments = this.getServiceLinePayments();
        List<ServiceLinePaymentData> other$serviceLinePayments = other.getServiceLinePayments();
        if (this$serviceLinePayments == null ? other$serviceLinePayments != null : !((Object)this$serviceLinePayments).equals(other$serviceLinePayments)) {
            return false;
        }
        BigDecimal this$totalClaimCoinsuranceAmount = this.getTotalClaimCoinsuranceAmount();
        BigDecimal other$totalClaimCoinsuranceAmount = other.getTotalClaimCoinsuranceAmount();
        return !(this$totalClaimCoinsuranceAmount == null ? other$totalClaimCoinsuranceAmount != null : !((Object)this$totalClaimCoinsuranceAmount).equals(other$totalClaimCoinsuranceAmount));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FqhcPaymentData;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        BigDecimal $geographicAdjustmentFactor = this.getGeographicAdjustmentFactor();
        result = result * 59 + ($geographicAdjustmentFactor == null ? 43 : ((Object)$geographicAdjustmentFactor).hashCode());
        List<ServiceLinePaymentData> $serviceLinePayments = this.getServiceLinePayments();
        result = result * 59 + ($serviceLinePayments == null ? 43 : ((Object)$serviceLinePayments).hashCode());
        BigDecimal $totalClaimCoinsuranceAmount = this.getTotalClaimCoinsuranceAmount();
        result = result * 59 + ($totalClaimCoinsuranceAmount == null ? 43 : ((Object)$totalClaimCoinsuranceAmount).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "FqhcPaymentData(geographicAdjustmentFactor=" + this.getGeographicAdjustmentFactor() + ", serviceLinePayments=" + this.getServiceLinePayments() + ", totalClaimCoinsuranceAmount=" + this.getTotalClaimCoinsuranceAmount() + ")";
    }

    @Generated
    public FqhcPaymentData() {
    }
}

