/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.fqhc.api.v2;

import gov.cms.fiss.pricers.common.api.ReturnCodeData;
import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithTwoFractionDigits;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.math.RoundingMode;
import lombok.Generated;

@Schema(description="The calculated result for a service line.")
public class ServiceLinePaymentData {
    @BigDecimalScale
    @DecimalMin(value="0")
    @DecimalMax(value="999999999.99")
    @Digits(integer=9, fraction=2)
    @NotNull
    @Schema(description="The add-on payment.", example="90.25", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="O-LITEM-ADD-ON-PYMT", value="PIC 9(09)V99")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="999999999.99") @Digits(integer=9, fraction=2) @NotNull @FixedValue BigDecimal addOnPayment = BigDecimal.ZERO.setScale(2, RoundingMode.UNNECESSARY);
    @BigDecimalScale
    @NotNull
    @Schema(description="The coinsurance amount.", example="4000.60", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="O-LITEM-COIN", value="PIC 9(09)V99")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal coinsuranceAmount = BigDecimal.ZERO.setScale(2, RoundingMode.UNNECESSARY);
    @Max(value=450L)
    @Min(value=0L)
    @NotNull
    @Schema(description="The payment line number; matches the corresponding line number in the claim service lines.", example="1")
    private @Max(value=450L) @Min(value=0L) @NotNull int lineNumber;
    @BigDecimalScale
    @Schema(description="The Maryland Primary Care Program (MDPCP) reduction amount.", example="250.80")
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal mdpcpReductionAmount = BigDecimalUtils.ZERO;
    @BigDecimalScale
    @NotNull
    @Schema(description="The line payment.", example="250.99", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="O-LITEM-PYMT", value="PIC 9(09)V99")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal payment = BigDecimal.ZERO.setScale(2, RoundingMode.UNNECESSARY);
    @NotNull
    @Valid
    private ReturnCodeData returnCodeData;

    @Generated
    public BigDecimal getAddOnPayment() {
        return this.addOnPayment;
    }

    @Generated
    public BigDecimal getCoinsuranceAmount() {
        return this.coinsuranceAmount;
    }

    @Generated
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Generated
    public BigDecimal getMdpcpReductionAmount() {
        return this.mdpcpReductionAmount;
    }

    @Generated
    public BigDecimal getPayment() {
        return this.payment;
    }

    @Generated
    public ReturnCodeData getReturnCodeData() {
        return this.returnCodeData;
    }

    @Generated
    public void setAddOnPayment(BigDecimal addOnPayment) {
        this.addOnPayment = addOnPayment;
    }

    @Generated
    public void setCoinsuranceAmount(BigDecimal coinsuranceAmount) {
        this.coinsuranceAmount = coinsuranceAmount;
    }

    @Generated
    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    @Generated
    public void setMdpcpReductionAmount(BigDecimal mdpcpReductionAmount) {
        this.mdpcpReductionAmount = mdpcpReductionAmount;
    }

    @Generated
    public void setPayment(BigDecimal payment) {
        this.payment = payment;
    }

    @Generated
    public void setReturnCodeData(ReturnCodeData returnCodeData) {
        this.returnCodeData = returnCodeData;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceLinePaymentData)) {
            return false;
        }
        ServiceLinePaymentData other = (ServiceLinePaymentData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLineNumber() != other.getLineNumber()) {
            return false;
        }
        BigDecimal this$addOnPayment = this.getAddOnPayment();
        BigDecimal other$addOnPayment = other.getAddOnPayment();
        if (this$addOnPayment == null ? other$addOnPayment != null : !((Object)this$addOnPayment).equals(other$addOnPayment)) {
            return false;
        }
        BigDecimal this$coinsuranceAmount = this.getCoinsuranceAmount();
        BigDecimal other$coinsuranceAmount = other.getCoinsuranceAmount();
        if (this$coinsuranceAmount == null ? other$coinsuranceAmount != null : !((Object)this$coinsuranceAmount).equals(other$coinsuranceAmount)) {
            return false;
        }
        BigDecimal this$mdpcpReductionAmount = this.getMdpcpReductionAmount();
        BigDecimal other$mdpcpReductionAmount = other.getMdpcpReductionAmount();
        if (this$mdpcpReductionAmount == null ? other$mdpcpReductionAmount != null : !((Object)this$mdpcpReductionAmount).equals(other$mdpcpReductionAmount)) {
            return false;
        }
        BigDecimal this$payment = this.getPayment();
        BigDecimal other$payment = other.getPayment();
        if (this$payment == null ? other$payment != null : !((Object)this$payment).equals(other$payment)) {
            return false;
        }
        ReturnCodeData this$returnCodeData = this.getReturnCodeData();
        ReturnCodeData other$returnCodeData = other.getReturnCodeData();
        return !(this$returnCodeData == null ? other$returnCodeData != null : !((Object)this$returnCodeData).equals(other$returnCodeData));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ServiceLinePaymentData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLineNumber();
        BigDecimal $addOnPayment = this.getAddOnPayment();
        result = result * 59 + ($addOnPayment == null ? 43 : ((Object)$addOnPayment).hashCode());
        BigDecimal $coinsuranceAmount = this.getCoinsuranceAmount();
        result = result * 59 + ($coinsuranceAmount == null ? 43 : ((Object)$coinsuranceAmount).hashCode());
        BigDecimal $mdpcpReductionAmount = this.getMdpcpReductionAmount();
        result = result * 59 + ($mdpcpReductionAmount == null ? 43 : ((Object)$mdpcpReductionAmount).hashCode());
        BigDecimal $payment = this.getPayment();
        result = result * 59 + ($payment == null ? 43 : ((Object)$payment).hashCode());
        ReturnCodeData $returnCodeData = this.getReturnCodeData();
        result = result * 59 + ($returnCodeData == null ? 43 : ((Object)$returnCodeData).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ServiceLinePaymentData(addOnPayment=" + this.getAddOnPayment() + ", coinsuranceAmount=" + this.getCoinsuranceAmount() + ", lineNumber=" + this.getLineNumber() + ", mdpcpReductionAmount=" + this.getMdpcpReductionAmount() + ", payment=" + this.getPayment() + ", returnCodeData=" + this.getReturnCodeData() + ")";
    }

    @Generated
    public ServiceLinePaymentData() {
    }
}

