/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.fqhc.core.rules.validation.rates.summary;

import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.fqhc.api.v2.IoceServiceLineData;
import gov.cms.fiss.pricers.fqhc.api.v2.ServiceLinePaymentData;
import gov.cms.fiss.pricers.fqhc.core.FqhcPricerContext;
import gov.cms.fiss.pricers.fqhc.core.ServiceLineContext;
import gov.cms.fiss.pricers.fqhc.core.daily.DailyRates;
import gov.cms.fiss.pricers.fqhc.core.daily.DaySummary;

public class InitializeDaySummary
implements CalculationRule<IoceServiceLineData, ServiceLinePaymentData, ServiceLineContext> {
    @Override
    public void calculate(ServiceLineContext calculationContext) {
        IoceServiceLineData ioceServiceLine = (IoceServiceLineData)calculationContext.getInput();
        FqhcPricerContext fqhcPricerContext = calculationContext.getFqhcPricerContext();
        @FixedValue DaySummary summary = fqhcPricerContext.getDaySummary(ioceServiceLine.getDateOfService());
        if (summary == null) {
            DailyRates dailyRates = calculationContext.getDailyRates();
            summary = new DaySummary(ioceServiceLine.getDateOfService(), dailyRates.getDailyBaseRate(), dailyRates.getDailyIopRateLte3(), dailyRates.getDailyIopRateGte4(), dailyRates.getDailyGafRate(), dailyRates.getDailyAddRate());
        }
        fqhcPricerContext.applyDaySummary(ioceServiceLine.getDateOfService(), summary);
    }
}

