/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.fqhc.core.tables;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.Pattern;
import java.math.BigDecimal;
import java.time.LocalDate;
import javax.annotation.concurrent.Immutable;
import lombok.Generated;

@JsonDeserialize(builder=GAFRateTableEntryBuilder.class)
@JsonPropertyOrder(value={"carrierLocality", "effectiveDate", "geographicalAdjFactor"})
@Immutable
public class GAFRateTableEntry {
    @Pattern(regexp="\\d{7}")
    private final @Pattern(regexp="\\d{7}") String carrierLocality;
    private final LocalDate effectiveDate;
    @Digits(integer=1, fraction=3)
    private final @Digits(integer=1, fraction=3) BigDecimal geographicalAdjFactor;

    @Generated
    GAFRateTableEntry(String carrierLocality, LocalDate effectiveDate, BigDecimal geographicalAdjFactor) {
        this.carrierLocality = carrierLocality;
        this.effectiveDate = effectiveDate;
        this.geographicalAdjFactor = geographicalAdjFactor;
    }

    @Generated
    public static GAFRateTableEntryBuilder builder() {
        return new GAFRateTableEntryBuilder();
    }

    @Generated
    public String getCarrierLocality() {
        return this.carrierLocality;
    }

    @Generated
    public LocalDate getEffectiveDate() {
        return this.effectiveDate;
    }

    @Generated
    public BigDecimal getGeographicalAdjFactor() {
        return this.geographicalAdjFactor;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class GAFRateTableEntryBuilder {
        @Generated
        private String carrierLocality;
        @Generated
        private LocalDate effectiveDate;
        @Generated
        private BigDecimal geographicalAdjFactor;

        @Generated
        GAFRateTableEntryBuilder() {
        }

        @Generated
        public GAFRateTableEntryBuilder carrierLocality(String carrierLocality) {
            this.carrierLocality = carrierLocality;
            return this;
        }

        @Generated
        public GAFRateTableEntryBuilder effectiveDate(LocalDate effectiveDate) {
            this.effectiveDate = effectiveDate;
            return this;
        }

        @Generated
        public GAFRateTableEntryBuilder geographicalAdjFactor(BigDecimal geographicalAdjFactor) {
            this.geographicalAdjFactor = geographicalAdjFactor;
            return this;
        }

        @Generated
        public GAFRateTableEntry build() {
            return new GAFRateTableEntry(this.carrierLocality, this.effectiveDate, this.geographicalAdjFactor);
        }

        @Generated
        public String toString() {
            return "GAFRateTableEntry.GAFRateTableEntryBuilder(carrierLocality=" + this.carrierLocality + ", effectiveDate=" + this.effectiveDate + ", geographicalAdjFactor=" + this.geographicalAdjFactor + ")";
        }
    }

    @Generated
    public static final class Fields {
        public static final String CARRIER_LOCALITY = "carrierLocality";
        public static final String EFFECTIVE_DATE = "effectiveDate";
        public static final String GEOGRAPHICAL_ADJ_FACTOR = "geographicalAdjFactor";
    }

    public static final class GAFRateKey {
        private final String carrierLocality;
        private final LocalDate serviceDate;

        @Generated
        public GAFRateKey(String carrierLocality, LocalDate serviceDate) {
            this.carrierLocality = carrierLocality;
            this.serviceDate = serviceDate;
        }

        @Generated
        public String getCarrierLocality() {
            return this.carrierLocality;
        }

        @Generated
        public LocalDate getServiceDate() {
            return this.serviceDate;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GAFRateKey)) {
                return false;
            }
            GAFRateKey other = (GAFRateKey)o;
            String this$carrierLocality = this.getCarrierLocality();
            String other$carrierLocality = other.getCarrierLocality();
            if (this$carrierLocality == null ? other$carrierLocality != null : !this$carrierLocality.equals(other$carrierLocality)) {
                return false;
            }
            LocalDate this$serviceDate = this.getServiceDate();
            LocalDate other$serviceDate = other.getServiceDate();
            return !(this$serviceDate == null ? other$serviceDate != null : !((Object)this$serviceDate).equals(other$serviceDate));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $carrierLocality = this.getCarrierLocality();
            result = result * 59 + ($carrierLocality == null ? 43 : $carrierLocality.hashCode());
            LocalDate $serviceDate = this.getServiceDate();
            result = result * 59 + ($serviceDate == null ? 43 : ((Object)$serviceDate).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "GAFRateTableEntry.GAFRateKey(carrierLocality=" + this.getCarrierLocality() + ", serviceDate=" + this.getServiceDate() + ")";
        }
    }
}

