/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.fqhc.core.tables;

import gov.cms.fiss.pricers.common.csv.CsvContentReader;
import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.common.csv.LookupGenerator;
import gov.cms.fiss.pricers.fqhc.core.tables.GAFRateTableEntry;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.BinaryOperator;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GAFRateTableEntryLookupGenerator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GAFRateTableEntryLookupGenerator.class);
    private static final String CSV_FILE_PATTERN = "/gaf-%s.csv";
    private final CsvContentReader<GAFRateTableEntry> contentProvider = new CsvContentReader<GAFRateTableEntry>(GAFRateTableEntry.class).customizeSchema(CsvContentReader.HEADER_ROW_CUSTOMIZER);

    public GAFRateTableEntryLookupGenerator(CsvIngestionConfiguration csvIngestionConfiguration) {
        if (!csvIngestionConfiguration.isValidationEnabled()) {
            this.contentProvider.disableValidation();
        }
    }

    public Map<String, NavigableMap<LocalDate, BigDecimal>> generate(int fiscalYear) {
        return this.generate(String.format(CSV_FILE_PATTERN, fiscalYear));
    }

    public Map<String, NavigableMap<LocalDate, BigDecimal>> generate(String csvFilename) {
        List<GAFRateTableEntry> content = this.contentProvider.read(csvFilename);
        Collector<GAFRateTableEntry, ?, NavigableMap> collector = Collectors.toMap(GAFRateTableEntry::getEffectiveDate, GAFRateTableEntry::getGeographicalAdjFactor, BinaryOperator.maxBy(Comparator.naturalOrder()), TreeMap::new);
        return LookupGenerator.generateCrossReferenceToMap(GAFRateTableEntry::getCarrierLocality, content, HashMap::new, collector);
    }
}

