/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.validation;

import io.dropwizard.jersey.validation.ConstraintMessage;
import io.dropwizard.jersey.validation.JerseyViolationException;
import io.dropwizard.jersey.validation.ValidationErrorMessage;
import jakarta.validation.ConstraintViolation;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.glassfish.jersey.server.model.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class JerseyViolationExceptionMapper
implements ExceptionMapper<JerseyViolationException> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JerseyViolationExceptionMapper.class);

    @Override
    public Response toResponse(JerseyViolationException exception) {
        LOGGER.debug("Object validation failure", exception);
        Set<ConstraintViolation<?>> violations = exception.getConstraintViolations();
        Invocable invocable = exception.getInvocable();
        List<String> errors = exception.getConstraintViolations().stream().map(violation -> ConstraintMessage.getMessage(violation, invocable)).collect(Collectors.toList());
        int status = ConstraintMessage.determineStatus(violations, invocable);
        return Response.status(status).entity(new ValidationErrorMessage(errors)).build();
    }
}

