/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics.jetty11;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.RatioGauge;
import com.codahale.metrics.Timer;
import com.codahale.metrics.annotation.ResponseMeteredLevel;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.server.AsyncContextState;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.Request;

public class InstrumentedHttpChannelListener
implements HttpChannel.Listener {
    private static final String START_ATTR = InstrumentedHttpChannelListener.class.getName() + ".start";
    private static final Set<ResponseMeteredLevel> COARSE_METER_LEVELS = EnumSet.of(ResponseMeteredLevel.COARSE, ResponseMeteredLevel.ALL);
    private static final Set<ResponseMeteredLevel> DETAILED_METER_LEVELS = EnumSet.of(ResponseMeteredLevel.DETAILED, ResponseMeteredLevel.ALL);
    private final MetricRegistry metricRegistry;
    private final Timer requests;
    private final Timer dispatches;
    private final Counter activeRequests;
    private final Counter activeDispatches;
    private final Counter activeSuspended;
    private final Meter asyncDispatches;
    private final Meter asyncTimeouts;
    private final ResponseMeteredLevel responseMeteredLevel;
    private final List<Meter> responses;
    private final Map<Integer, Meter> responseCodeMeters;
    private final String prefix;
    private final Timer getRequests;
    private final Timer postRequests;
    private final Timer headRequests;
    private final Timer putRequests;
    private final Timer deleteRequests;
    private final Timer optionsRequests;
    private final Timer traceRequests;
    private final Timer connectRequests;
    private final Timer moveRequests;
    private final Timer otherRequests;
    private final AsyncListener listener;

    public InstrumentedHttpChannelListener(MetricRegistry registry) {
        this(registry, null, ResponseMeteredLevel.COARSE);
    }

    public InstrumentedHttpChannelListener(MetricRegistry registry, String pref) {
        this(registry, pref, ResponseMeteredLevel.COARSE);
    }

    public InstrumentedHttpChannelListener(MetricRegistry registry, String pref, ResponseMeteredLevel responseMeteredLevel) {
        this.metricRegistry = registry;
        this.prefix = pref == null ? this.getClass().getName() : pref;
        this.requests = this.metricRegistry.timer(MetricRegistry.name(this.prefix, "requests"));
        this.dispatches = this.metricRegistry.timer(MetricRegistry.name(this.prefix, "dispatches"));
        this.activeRequests = this.metricRegistry.counter(MetricRegistry.name(this.prefix, "active-requests"));
        this.activeDispatches = this.metricRegistry.counter(MetricRegistry.name(this.prefix, "active-dispatches"));
        this.activeSuspended = this.metricRegistry.counter(MetricRegistry.name(this.prefix, "active-suspended"));
        this.asyncDispatches = this.metricRegistry.meter(MetricRegistry.name(this.prefix, "async-dispatches"));
        this.asyncTimeouts = this.metricRegistry.meter(MetricRegistry.name(this.prefix, "async-timeouts"));
        this.responseMeteredLevel = responseMeteredLevel;
        this.responseCodeMeters = DETAILED_METER_LEVELS.contains((Object)responseMeteredLevel) ? new ConcurrentHashMap() : Collections.emptyMap();
        this.responses = COARSE_METER_LEVELS.contains((Object)responseMeteredLevel) ? Collections.unmodifiableList(Arrays.asList(registry.meter(MetricRegistry.name(this.prefix, "1xx-responses")), registry.meter(MetricRegistry.name(this.prefix, "2xx-responses")), registry.meter(MetricRegistry.name(this.prefix, "3xx-responses")), registry.meter(MetricRegistry.name(this.prefix, "4xx-responses")), registry.meter(MetricRegistry.name(this.prefix, "5xx-responses")))) : Collections.emptyList();
        this.getRequests = this.metricRegistry.timer(MetricRegistry.name(this.prefix, "get-requests"));
        this.postRequests = this.metricRegistry.timer(MetricRegistry.name(this.prefix, "post-requests"));
        this.headRequests = this.metricRegistry.timer(MetricRegistry.name(this.prefix, "head-requests"));
        this.putRequests = this.metricRegistry.timer(MetricRegistry.name(this.prefix, "put-requests"));
        this.deleteRequests = this.metricRegistry.timer(MetricRegistry.name(this.prefix, "delete-requests"));
        this.optionsRequests = this.metricRegistry.timer(MetricRegistry.name(this.prefix, "options-requests"));
        this.traceRequests = this.metricRegistry.timer(MetricRegistry.name(this.prefix, "trace-requests"));
        this.connectRequests = this.metricRegistry.timer(MetricRegistry.name(this.prefix, "connect-requests"));
        this.moveRequests = this.metricRegistry.timer(MetricRegistry.name(this.prefix, "move-requests"));
        this.otherRequests = this.metricRegistry.timer(MetricRegistry.name(this.prefix, "other-requests"));
        this.metricRegistry.register(MetricRegistry.name(this.prefix, "percent-4xx-1m"), new RatioGauge(){

            @Override
            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of(((Meter)InstrumentedHttpChannelListener.this.responses.get(3)).getOneMinuteRate(), InstrumentedHttpChannelListener.this.requests.getOneMinuteRate());
            }
        });
        this.metricRegistry.register(MetricRegistry.name(this.prefix, "percent-4xx-5m"), new RatioGauge(){

            @Override
            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of(((Meter)InstrumentedHttpChannelListener.this.responses.get(3)).getFiveMinuteRate(), InstrumentedHttpChannelListener.this.requests.getFiveMinuteRate());
            }
        });
        this.metricRegistry.register(MetricRegistry.name(this.prefix, "percent-4xx-15m"), new RatioGauge(){

            @Override
            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of(((Meter)InstrumentedHttpChannelListener.this.responses.get(3)).getFifteenMinuteRate(), InstrumentedHttpChannelListener.this.requests.getFifteenMinuteRate());
            }
        });
        this.metricRegistry.register(MetricRegistry.name(this.prefix, "percent-5xx-1m"), new RatioGauge(){

            @Override
            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of(((Meter)InstrumentedHttpChannelListener.this.responses.get(4)).getOneMinuteRate(), InstrumentedHttpChannelListener.this.requests.getOneMinuteRate());
            }
        });
        this.metricRegistry.register(MetricRegistry.name(this.prefix, "percent-5xx-5m"), new RatioGauge(){

            @Override
            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of(((Meter)InstrumentedHttpChannelListener.this.responses.get(4)).getFiveMinuteRate(), InstrumentedHttpChannelListener.this.requests.getFiveMinuteRate());
            }
        });
        this.metricRegistry.register(MetricRegistry.name(this.prefix, "percent-5xx-15m"), new RatioGauge(){

            @Override
            public RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of(((Meter)InstrumentedHttpChannelListener.this.responses.get(4)).getFifteenMinuteRate(), InstrumentedHttpChannelListener.this.requests.getFifteenMinuteRate());
            }
        });
        this.listener = new AsyncAttachingListener();
    }

    @Override
    public void onRequestBegin(Request request) {
    }

    @Override
    public void onBeforeDispatch(Request request) {
        this.before(request);
    }

    @Override
    public void onDispatchFailure(Request request, Throwable failure) {
    }

    @Override
    public void onAfterDispatch(Request request) {
        this.after(request);
    }

    @Override
    public void onRequestContent(Request request, ByteBuffer content) {
    }

    @Override
    public void onRequestContentEnd(Request request) {
    }

    @Override
    public void onRequestTrailers(Request request) {
    }

    @Override
    public void onRequestEnd(Request request) {
    }

    @Override
    public void onRequestFailure(Request request, Throwable failure) {
    }

    @Override
    public void onResponseBegin(Request request) {
    }

    @Override
    public void onResponseCommit(Request request) {
    }

    @Override
    public void onResponseContent(Request request, ByteBuffer content) {
    }

    @Override
    public void onResponseEnd(Request request) {
    }

    @Override
    public void onResponseFailure(Request request, Throwable failure) {
    }

    @Override
    public void onComplete(Request request) {
    }

    private void before(Request request) {
        long start;
        this.activeDispatches.inc();
        HttpChannelState state = request.getHttpChannelState();
        if (state.isInitial()) {
            this.activeRequests.inc();
            start = request.getTimeStamp();
            state.addListener(this.listener);
        } else {
            start = System.currentTimeMillis();
            this.activeSuspended.dec();
            if (state.isAsyncStarted()) {
                this.asyncDispatches.mark();
            }
        }
        request.setAttribute(START_ATTR, start);
    }

    private void after(Request request) {
        long start = (Long)request.getAttribute(START_ATTR);
        long now = System.currentTimeMillis();
        long dispatched = now - start;
        this.activeDispatches.dec();
        this.dispatches.update(dispatched, TimeUnit.MILLISECONDS);
        HttpChannelState state = request.getHttpChannelState();
        if (state.isSuspended()) {
            this.activeSuspended.inc();
        } else if (state.isInitial()) {
            this.updateResponses(request, request.getResponse(), start, request.isHandled());
        }
    }

    private void updateResponses(HttpServletRequest request, HttpServletResponse response, long start, boolean isHandled) {
        if (isHandled) {
            this.mark(response.getStatus());
        } else {
            this.mark(404);
        }
        this.activeRequests.dec();
        long elapsedTime = System.currentTimeMillis() - start;
        this.requests.update(elapsedTime, TimeUnit.MILLISECONDS);
        this.requestTimer(request.getMethod()).update(elapsedTime, TimeUnit.MILLISECONDS);
    }

    private void mark(int statusCode) {
        int responseStatus;
        if (DETAILED_METER_LEVELS.contains((Object)this.responseMeteredLevel)) {
            this.getResponseCodeMeter(statusCode).mark();
        }
        if (COARSE_METER_LEVELS.contains((Object)this.responseMeteredLevel) && (responseStatus = statusCode / 100) >= 1 && responseStatus <= 5) {
            this.responses.get(responseStatus - 1).mark();
        }
    }

    private Meter getResponseCodeMeter(int statusCode) {
        return this.responseCodeMeters.computeIfAbsent(statusCode, sc -> this.metricRegistry.meter(MetricRegistry.name(this.prefix, String.format("%d-responses", sc))));
    }

    private Timer requestTimer(String method) {
        HttpMethod m4 = HttpMethod.fromString(method);
        if (m4 == null) {
            return this.otherRequests;
        }
        switch (m4) {
            case GET: {
                return this.getRequests;
            }
            case POST: {
                return this.postRequests;
            }
            case PUT: {
                return this.putRequests;
            }
            case HEAD: {
                return this.headRequests;
            }
            case DELETE: {
                return this.deleteRequests;
            }
            case OPTIONS: {
                return this.optionsRequests;
            }
            case TRACE: {
                return this.traceRequests;
            }
            case CONNECT: {
                return this.connectRequests;
            }
            case MOVE: {
                return this.moveRequests;
            }
        }
        return this.otherRequests;
    }

    private class AsyncAttachingListener
    implements AsyncListener {
        private AsyncAttachingListener() {
        }

        @Override
        public void onTimeout(AsyncEvent event) throws IOException {
        }

        @Override
        public void onStartAsync(AsyncEvent event) throws IOException {
            event.getAsyncContext().addListener(new InstrumentedAsyncListener());
        }

        @Override
        public void onError(AsyncEvent event) throws IOException {
        }

        @Override
        public void onComplete(AsyncEvent event) throws IOException {
        }
    }

    private class InstrumentedAsyncListener
    implements AsyncListener {
        private final long startTime = System.currentTimeMillis();

        InstrumentedAsyncListener() {
        }

        @Override
        public void onTimeout(AsyncEvent event) throws IOException {
            InstrumentedHttpChannelListener.this.asyncTimeouts.mark();
        }

        @Override
        public void onStartAsync(AsyncEvent event) throws IOException {
        }

        @Override
        public void onError(AsyncEvent event) throws IOException {
        }

        @Override
        public void onComplete(AsyncEvent event) throws IOException {
            AsyncContextState state = (AsyncContextState)event.getAsyncContext();
            HttpServletRequest request = (HttpServletRequest)state.getRequest();
            HttpServletResponse response = (HttpServletResponse)state.getResponse();
            InstrumentedHttpChannelListener.this.updateResponses(request, response, this.startTime, true);
            if (!state.getHttpChannelState().isSuspended()) {
                InstrumentedHttpChannelListener.this.activeSuspended.dec();
            }
        }
    }
}

