/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http;

import java.net.IDN;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.core5.util.TextUtils;

public class SystemDefaultDnsResolver
implements DnsResolver {
    public static final SystemDefaultDnsResolver INSTANCE = new SystemDefaultDnsResolver();

    @Override
    public InetAddress[] resolve(String host) throws UnknownHostException {
        try {
            String normalizedHost;
            if (TextUtils.isAllASCII(host)) {
                normalizedHost = host;
            } else {
                try {
                    normalizedHost = IDN.toASCII(host);
                }
                catch (IllegalArgumentException e) {
                    normalizedHost = host;
                }
            }
            return InetAddress.getAllByName(normalizedHost);
        }
        catch (UnknownHostException e) {
            int i2;
            String strippedHost = null;
            if (host.charAt(0) == '[' && (i2 = host.lastIndexOf(37)) != -1) {
                strippedHost = host.substring(0, i2) + "]";
            }
            if (strippedHost != null) {
                return InetAddress.getAllByName(strippedHost);
            }
            throw e;
        }
    }

    @Override
    public String resolveCanonicalHostname(String host) throws UnknownHostException {
        if (host == null) {
            return null;
        }
        InetAddress in = InetAddress.getByName(host);
        String canonicalServer = in.getCanonicalHostName();
        if (in.getHostAddress().contentEquals(canonicalServer)) {
            return host;
        }
        return canonicalServer;
    }
}

