/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import org.assertj.core.api.Abstract2DArrayAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.Index;
import org.assertj.core.error.ShouldHaveSameSizeAs;
import org.assertj.core.error.ShouldNotBeNull;
import org.assertj.core.error.SubarraysShouldHaveSameSize;
import org.assertj.core.error.array2d.Array2dElementShouldBeDeepEqual;
import org.assertj.core.internal.Boolean2DArrays;
import org.assertj.core.internal.Failures;
import org.assertj.core.util.VisibleForTesting;

public class Boolean2DArrayAssert
extends Abstract2DArrayAssert<Boolean2DArrayAssert, boolean[][], Boolean> {
    private final Failures failures = Failures.instance();
    @VisibleForTesting
    protected Boolean2DArrays boolean2dArrays = Boolean2DArrays.instance();

    public Boolean2DArrayAssert(boolean[][] actual) {
        super(actual, Boolean2DArrayAssert.class);
    }

    @Override
    public Boolean2DArrayAssert isDeepEqualTo(boolean[][] expected) {
        if (this.actual == expected) {
            return (Boolean2DArrayAssert)this.myself;
        }
        this.isNotNull();
        if (expected.length != ((boolean[][])this.actual).length) {
            throw this.failures.failure((AssertionInfo)this.info, ShouldHaveSameSizeAs.shouldHaveSameSizeAs(this.actual, expected, ((boolean[][])this.actual).length, expected.length));
        }
        for (int i2 = 0; i2 < ((boolean[][])this.actual).length; ++i2) {
            boolean[] actualSubArray = ((boolean[][])this.actual)[i2];
            boolean[] expectedSubArray = expected[i2];
            if (actualSubArray == expectedSubArray) continue;
            if (actualSubArray == null) {
                throw this.failures.failure((AssertionInfo)this.info, ShouldNotBeNull.shouldNotBeNull("actual[" + i2 + "]"));
            }
            if (expectedSubArray.length != actualSubArray.length) {
                throw this.failures.failure(this.info, SubarraysShouldHaveSameSize.subarraysShouldHaveSameSize(this.actual, expected, actualSubArray, actualSubArray.length, expectedSubArray, expectedSubArray.length, i2), this.info.representation().toStringOf(this.actual), this.info.representation().toStringOf(expected));
            }
            for (int j = 0; j < actualSubArray.length; ++j) {
                if (actualSubArray[j] == expectedSubArray[j]) continue;
                throw this.failures.failure(this.info, Array2dElementShouldBeDeepEqual.elementShouldBeEqual(actualSubArray[j], expectedSubArray[j], i2, j), this.info.representation().toStringOf(this.actual), this.info.representation().toStringOf(expected));
            }
        }
        return (Boolean2DArrayAssert)this.myself;
    }

    @Override
    public Boolean2DArrayAssert isEqualTo(Object expected) {
        return (Boolean2DArrayAssert)super.isEqualTo(expected);
    }

    @Override
    public void isNullOrEmpty() {
        this.boolean2dArrays.assertNullOrEmpty(this.info, (boolean[][])this.actual);
    }

    @Override
    public void isEmpty() {
        this.boolean2dArrays.assertEmpty(this.info, (boolean[][])this.actual);
    }

    @Override
    public Boolean2DArrayAssert isNotEmpty() {
        this.boolean2dArrays.assertNotEmpty(this.info, (boolean[][])this.actual);
        return (Boolean2DArrayAssert)this.myself;
    }

    @Override
    public Boolean2DArrayAssert hasDimensions(int expectedFirstDimension, int expectedSecondDimension) {
        this.boolean2dArrays.assertHasDimensions(this.info, (boolean[][])this.actual, expectedFirstDimension, expectedSecondDimension);
        return (Boolean2DArrayAssert)this.myself;
    }

    @Override
    public Boolean2DArrayAssert hasSameDimensionsAs(Object array) {
        this.boolean2dArrays.assertHasSameDimensionsAs(this.info, (boolean[][])this.actual, array);
        return (Boolean2DArrayAssert)this.myself;
    }

    public Boolean2DArrayAssert contains(boolean[] value, Index index) {
        this.boolean2dArrays.assertContains(this.info, (boolean[][])this.actual, value, index);
        return (Boolean2DArrayAssert)this.myself;
    }

    public Boolean2DArrayAssert doesNotContain(boolean[] value, Index index) {
        this.boolean2dArrays.assertDoesNotContain(this.info, (boolean[][])this.actual, value, index);
        return (Boolean2DArrayAssert)this.myself;
    }
}

