/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.apache5.connector;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.core.Configurable;
import jakarta.ws.rs.core.Configuration;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.glassfish.jersey.apache5.connector.Apache5Connector;
import org.glassfish.jersey.apache5.connector.LocalizationMessages;
import org.glassfish.jersey.client.Initializable;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.client.spi.ConnectorProvider;

public class Apache5ConnectorProvider
implements ConnectorProvider {
    @Override
    public Connector getConnector(Client client, Configuration runtimeConfig) {
        return new Apache5Connector(client, runtimeConfig);
    }

    public static HttpClient getHttpClient(Configurable<?> component) {
        return Apache5ConnectorProvider.getConnector(component).getHttpClient();
    }

    public static CookieStore getCookieStore(Configurable<?> component) {
        return Apache5ConnectorProvider.getConnector(component).getCookieStore();
    }

    private static Apache5Connector getConnector(Configurable<?> component) {
        if (!(component instanceof Initializable)) {
            throw new IllegalArgumentException(LocalizationMessages.INVALID_CONFIGURABLE_COMPONENT_TYPE(component.getClass().getName()));
        }
        Initializable initializable = (Initializable)((Object)component);
        Connector connector = initializable.getConfiguration().getConnector();
        if (connector == null) {
            initializable.preInitialize();
            connector = initializable.getConfiguration().getConnector();
        }
        if (connector instanceof Apache5Connector) {
            return (Apache5Connector)connector;
        }
        throw new IllegalArgumentException(LocalizationMessages.EXPECTED_CONNECTOR_PROVIDER_NOT_USED());
    }
}

