/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.provider;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestFactory;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.AnnotationBasedArgumentsProvider;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsUtils;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.util.ClassLoaderUtils;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.StringUtils;

class MethodArgumentsProvider
extends AnnotationBasedArgumentsProvider<MethodSource> {
    private static final Predicate<Method> isFactoryMethod = method -> CollectionUtils.isConvertibleToStream(method.getReturnType()) && !MethodArgumentsProvider.isTestMethod(method);

    MethodArgumentsProvider() {
    }

    @Override
    protected Stream<? extends Arguments> provideArguments(ExtensionContext context, MethodSource methodSource) {
        Class<?> testClass = context.getRequiredTestClass();
        Method testMethod = context.getRequiredTestMethod();
        Object testInstance = context.getTestInstance().orElse(null);
        String[] methodNames = methodSource.value();
        return Arrays.stream(methodNames).map(factoryMethodName -> MethodArgumentsProvider.findFactoryMethod(testClass, testMethod, factoryMethodName)).map(factoryMethod -> MethodArgumentsProvider.validateFactoryMethod(factoryMethod, testInstance)).map(factoryMethod -> context.getExecutableInvoker().invoke((Method)factoryMethod, (Object)testInstance)).flatMap(CollectionUtils::toStream).map(ArgumentsUtils::toArguments);
    }

    private static Method findFactoryMethod(Class<?> testClass, Method testMethod, String factoryMethodName) {
        String originalFactoryMethodName = factoryMethodName;
        if (StringUtils.isBlank(factoryMethodName)) {
            factoryMethodName = testMethod.getName();
            return MethodArgumentsProvider.findFactoryMethodBySimpleName(testClass, testMethod, factoryMethodName);
        }
        if (!MethodArgumentsProvider.looksLikeAFullyQualifiedMethodName(factoryMethodName)) {
            factoryMethodName = testClass.getName() + "#" + factoryMethodName;
        }
        Method factoryMethod = MethodArgumentsProvider.findFactoryMethodByFullyQualifiedName(testClass, testMethod, factoryMethodName);
        Preconditions.condition(isFactoryMethod.test(factoryMethod), () -> String.format("Could not find valid factory method [%s] for test class [%s] but found the following invalid candidate: %s", originalFactoryMethodName, testClass.getName(), factoryMethod));
        return factoryMethod;
    }

    private static boolean looksLikeAFullyQualifiedMethodName(String factoryMethodName) {
        if (factoryMethodName.contains("#")) {
            return true;
        }
        int indexOfFirstDot = factoryMethodName.indexOf(46);
        if (indexOfFirstDot == -1) {
            return false;
        }
        int indexOfLastOpeningParenthesis = factoryMethodName.lastIndexOf(40);
        if (indexOfLastOpeningParenthesis > 0) {
            return indexOfFirstDot < indexOfLastOpeningParenthesis;
        }
        return true;
    }

    static Method findFactoryMethodByFullyQualifiedName(Class<?> testClass, Method testMethod, String fullyQualifiedMethodName) {
        String[] methodParts = ReflectionUtils.parseFullyQualifiedMethodName(fullyQualifiedMethodName);
        String className = methodParts[0];
        String methodName = methodParts[1];
        String methodParameters = methodParts[2];
        ClassLoader classLoader = ClassLoaderUtils.getClassLoader(testClass);
        Class<?> clazz = ReflectionUtils.loadRequiredClass(className, classLoader);
        Method factoryMethod = ReflectionUtils.findMethod(clazz, methodName, methodParameters).orElse(null);
        if (factoryMethod != null) {
            return factoryMethod;
        }
        boolean explicitParameterListSpecified = StringUtils.isNotBlank(methodParameters) || fullyQualifiedMethodName.endsWith("()");
        Preconditions.condition(!explicitParameterListSpecified, () -> String.format("Could not find factory method [%s(%s)] in class [%s]", methodName, methodParameters, className));
        return MethodArgumentsProvider.findFactoryMethodBySimpleName(clazz, testMethod, methodName);
    }

    private static Method findFactoryMethodBySimpleName(Class<?> clazz, Method testMethod, String factoryMethodName) {
        Predicate<Method> isCandidate = candidate -> factoryMethodName.equals(candidate.getName()) && !testMethod.equals(candidate);
        List<Method> candidates = ReflectionUtils.findMethods(clazz, isCandidate);
        List factoryMethods = candidates.stream().filter(isFactoryMethod).collect(Collectors.toList());
        Preconditions.condition(factoryMethods.size() > 0, () -> {
            if (candidates.size() > 0) {
                return String.format("Could not find valid factory method [%s] in class [%s] but found the following invalid candidates: %s", factoryMethodName, clazz.getName(), candidates);
            }
            return String.format("Could not find factory method [%s] in class [%s]", factoryMethodName, clazz.getName());
        });
        Preconditions.condition(factoryMethods.size() == 1, () -> String.format("%d factory methods named [%s] were found in class [%s]: %s", factoryMethods.size(), factoryMethodName, clazz.getName(), factoryMethods));
        return (Method)factoryMethods.get(0);
    }

    private static boolean isTestMethod(Method candidate) {
        return AnnotationSupport.isAnnotated(candidate, Test.class) || AnnotationSupport.isAnnotated(candidate, TestTemplate.class) || AnnotationSupport.isAnnotated(candidate, TestFactory.class);
    }

    private static Method validateFactoryMethod(Method factoryMethod, Object testInstance) {
        Preconditions.condition(factoryMethod.getDeclaringClass().isInstance(testInstance) || ReflectionUtils.isStatic(factoryMethod), () -> String.format("Method '%s' must be static: local factory methods must be static unless the PER_CLASS @TestInstance lifecycle mode is used; external factory methods must always be static.", factoryMethod.toGenericString()));
        return factoryMethod;
    }
}

