/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem.spring.common;

import java.net.URI;
import java.util.Arrays;
import java.util.Optional;
import org.apiguardian.api.API;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.zalando.problem.Problem;
import org.zalando.problem.ProblemBuilder;
import org.zalando.problem.Status;
import org.zalando.problem.StatusType;
import org.zalando.problem.ThrowableProblem;
import org.zalando.problem.spring.common.Lists;
import org.zalando.problem.spring.common.ResponseStatusAdapter;

@API(status=API.Status.INTERNAL)
public interface AdviceTrait {
    default public ThrowableProblem toProblem(Throwable throwable) {
        StatusType status = Optional.ofNullable(this.resolveResponseStatus(throwable)).map(ResponseStatusAdapter::new).orElse(Status.INTERNAL_SERVER_ERROR);
        return this.toProblem(throwable, status);
    }

    @API(status=API.Status.MAINTAINED)
    default public ResponseStatus resolveResponseStatus(Throwable type) {
        ResponseStatus candidate = (ResponseStatus)AnnotatedElementUtils.findMergedAnnotation(type.getClass(), ResponseStatus.class);
        return candidate == null && type.getCause() != null ? this.resolveResponseStatus(type.getCause()) : candidate;
    }

    default public ThrowableProblem toProblem(Throwable throwable, StatusType status) {
        return this.toProblem(throwable, status, Problem.DEFAULT_TYPE);
    }

    default public ThrowableProblem toProblem(Throwable throwable, StatusType status, URI type) {
        ThrowableProblem problem = this.prepare(throwable, status, type).build();
        StackTraceElement[] stackTrace = this.createStackTrace(throwable);
        problem.setStackTrace(stackTrace);
        return problem;
    }

    default public ProblemBuilder prepare(Throwable throwable, StatusType status, URI type) {
        return Problem.builder().withType(type).withTitle(status.getReasonPhrase()).withStatus(status).withDetail(throwable.getMessage()).withCause(Optional.ofNullable(throwable.getCause()).filter(cause -> this.isCausalChainsEnabled()).map(this::toProblem).orElse(null));
    }

    default public StackTraceElement[] createStackTrace(Throwable throwable) {
        Throwable cause = throwable.getCause();
        if (cause == null || !this.isCausalChainsEnabled()) {
            return throwable.getStackTrace();
        }
        StackTraceElement[] next = cause.getStackTrace();
        StackTraceElement[] current = throwable.getStackTrace();
        int length = current.length - Lists.lengthOfTrailingPartialSubList(Arrays.asList(next), Arrays.asList(current));
        StackTraceElement[] stackTrace = new StackTraceElement[length];
        System.arraycopy(current, 0, stackTrace, 0, length);
        return stackTrace;
    }

    default public boolean isCausalChainsEnabled() {
        return false;
    }

    default public ResponseEntity<Problem> process(ResponseEntity<Problem> entity) {
        return entity;
    }
}

