// Generated by delombok at Tue Dec 09 21:35:40 UTC 2025
package gov.cms.fiss.pricers.fqhc.api.v2;

import gov.cms.fiss.pricers.common.api.PaymentData;
import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithTwoFractionDigits;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

@Schema(description = "The FQHC prospective payment data.", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "O-CLAIM-LEVEL-OUTPUT", value = "<structure>)")})})
public class FqhcPaymentData extends PaymentData {
  @BigDecimalScale(scale = 4)
  @DecimalMin("0")
  @DecimalMax("9.9999")
  @Digits(integer = 1, fraction = 4)
  @NotNull
  @Schema(description = "The location-based adjustment factor.", example = "1.4533", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "O-GEO-ADJ-FACT", value = "PIC 9(01)V9(04)")})})
  @FixedValue
  private BigDecimal geographicAdjustmentFactor = BigDecimal.ZERO.setScale(4, RoundingMode.UNNECESSARY);
  @ArraySchema(arraySchema = @Schema(description = "The payments related to the services provided."), extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "O-LINE-LEVEL-OUTPUT", value = "<structure>")})}, uniqueItems = true)
  @NotEmpty
  @Size(max = 450)
  @Valid
  private List<@NotNull ServiceLinePaymentData> serviceLinePayments;
  @BigDecimalScale
  @NotNull
  @Schema(description = "The total claim coinsurance amount.", example = "199.99", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "O-TOT-CLM-COIN", value = "PIC 9(09)V99")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal totalClaimCoinsuranceAmount = BigDecimal.ZERO.setScale(2, RoundingMode.UNNECESSARY);

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getGeographicAdjustmentFactor() {
    return this.geographicAdjustmentFactor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<@NotNull ServiceLinePaymentData> getServiceLinePayments() {
    return this.serviceLinePayments;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getTotalClaimCoinsuranceAmount() {
    return this.totalClaimCoinsuranceAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setGeographicAdjustmentFactor(final BigDecimal geographicAdjustmentFactor) {
    this.geographicAdjustmentFactor = geographicAdjustmentFactor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setServiceLinePayments(final List<@NotNull ServiceLinePaymentData> serviceLinePayments) {
    this.serviceLinePayments = serviceLinePayments;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTotalClaimCoinsuranceAmount(final BigDecimal totalClaimCoinsuranceAmount) {
    this.totalClaimCoinsuranceAmount = totalClaimCoinsuranceAmount;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof FqhcPaymentData)) return false;
    final FqhcPaymentData other = (FqhcPaymentData) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    if (!super.equals(o)) return false;
    final java.lang.Object this$geographicAdjustmentFactor = this.getGeographicAdjustmentFactor();
    final java.lang.Object other$geographicAdjustmentFactor = other.getGeographicAdjustmentFactor();
    if (this$geographicAdjustmentFactor == null ? other$geographicAdjustmentFactor != null : !this$geographicAdjustmentFactor.equals(other$geographicAdjustmentFactor)) return false;
    final java.lang.Object this$serviceLinePayments = this.getServiceLinePayments();
    final java.lang.Object other$serviceLinePayments = other.getServiceLinePayments();
    if (this$serviceLinePayments == null ? other$serviceLinePayments != null : !this$serviceLinePayments.equals(other$serviceLinePayments)) return false;
    final java.lang.Object this$totalClaimCoinsuranceAmount = this.getTotalClaimCoinsuranceAmount();
    final java.lang.Object other$totalClaimCoinsuranceAmount = other.getTotalClaimCoinsuranceAmount();
    if (this$totalClaimCoinsuranceAmount == null ? other$totalClaimCoinsuranceAmount != null : !this$totalClaimCoinsuranceAmount.equals(other$totalClaimCoinsuranceAmount)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof FqhcPaymentData;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = super.hashCode();
    final java.lang.Object $geographicAdjustmentFactor = this.getGeographicAdjustmentFactor();
    result = result * PRIME + ($geographicAdjustmentFactor == null ? 43 : $geographicAdjustmentFactor.hashCode());
    final java.lang.Object $serviceLinePayments = this.getServiceLinePayments();
    result = result * PRIME + ($serviceLinePayments == null ? 43 : $serviceLinePayments.hashCode());
    final java.lang.Object $totalClaimCoinsuranceAmount = this.getTotalClaimCoinsuranceAmount();
    result = result * PRIME + ($totalClaimCoinsuranceAmount == null ? 43 : $totalClaimCoinsuranceAmount.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "FqhcPaymentData(geographicAdjustmentFactor=" + this.getGeographicAdjustmentFactor() + ", serviceLinePayments=" + this.getServiceLinePayments() + ", totalClaimCoinsuranceAmount=" + this.getTotalClaimCoinsuranceAmount() + ")";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public FqhcPaymentData() {
  }
}
