/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.application.errors;

import gov.cms.fiss.pricers.common.application.Reporting;
import gov.cms.fiss.pricers.common.application.errors.InputValidationError;
import gov.cms.fiss.pricers.common.application.request.RequestContentExtractor;
import io.dropwizard.jersey.validation.JerseyViolationException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.Path;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.problem.Problem;
import org.zalando.problem.Status;
import org.zalando.problem.violations.ConstraintViolationProblem;
import org.zalando.problem.violations.Violation;

@Provider
public class InputValidationExceptionMapper
implements ExceptionMapper<JerseyViolationException> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(InputValidationExceptionMapper.class);

    @Override
    public Response toResponse(JerseyViolationException exception) {
        InputValidationError error = this.generateError(exception);
        Reporting.reportEventToNR("InvalidInput", "errorMessages", exception.getMessage());
        LOGGER.debug("Failed input validation with errors: {}", (Object)error.getErrors());
        if (null == RequestContentExtractor.rfc7807Support()) {
            return Response.status(error.getCode()).type("application/json").entity(error).build();
        }
        return Response.status(Status.BAD_REQUEST.getStatusCode()).type("application/problem+json").entity(this.generateProblem(exception)).build();
    }

    private ConstraintViolationProblem generateProblem(JerseyViolationException exception) {
        List<Violation> violations = exception.getConstraintViolations().stream().map(cv -> new Violation(cv.getPropertyPath().toString(), cv.getMessage())).sorted(Comparator.comparing(Violation::getField).thenComparing(Violation::getMessage)).collect(Collectors.toList());
        return new ConstraintViolationProblem(Problem.DEFAULT_TYPE, Status.BAD_REQUEST, violations);
    }

    private InputValidationError generateError(JerseyViolationException exception) {
        Set<ConstraintViolation<?>> violations = exception.getConstraintViolations();
        ArrayList<String> errorMessages = new ArrayList<String>();
        for (ConstraintViolation<?> violation : violations) {
            ArrayList<String> propertyPath = new ArrayList<String>();
            for (Path.Node node : violation.getPropertyPath()) {
                propertyPath.add(node.toString());
            }
            int pathSize = propertyPath.size();
            errorMessages.add(String.format("%s %s", String.join((CharSequence)".", pathSize > 2 ? propertyPath.subList(2, pathSize) : propertyPath), violation.getMessage()));
        }
        return new InputValidationError(errorMessages);
    }
}

