/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.hha.core.rules.final_calculation;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.hha.api.v2.HhaClaimPricingRequest;
import gov.cms.fiss.pricers.hha.api.v2.HhaClaimPricingResponse;
import gov.cms.fiss.pricers.hha.api.v2.RevenueLineData;
import gov.cms.fiss.pricers.hha.api.v2.RevenuePaymentData;
import gov.cms.fiss.pricers.hha.core.HhaPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

public class CalculateLupaPayment
implements CalculationRule<HhaClaimPricingRequest, HhaClaimPricingResponse, HhaPricerContext> {
    @Override
    public boolean shouldExecute(HhaPricerContext calculationContext) {
        return !calculationContext.isPartialEpisodePaymentCalculated();
    }

    @Override
    public void calculate(HhaPricerContext calculationContext) {
        List<RevenueLineData> inputRevenue = calculationContext.getRevenueLines();
        List<RevenuePaymentData> outputRevenueData = calculationContext.getRevenuePayments();
        for (int i2 = 0; i2 < inputRevenue.size(); ++i2) {
            RevenueLineData inputData = inputRevenue.get(i2);
            RevenuePaymentData outputRevenueEntry = outputRevenueData.get(i2);
            BigDecimal federalAdjustment = BigDecimal.valueOf(inputData.getQuantityOfCoveredVisits()).multiply(outputRevenueEntry.getDollarRate());
            BigDecimal revenueCost = calculationContext.calculateAdjustedCost(federalAdjustment);
            outputRevenueEntry.setCost(revenueCost.setScale(2, RoundingMode.HALF_UP));
            BigDecimal federalLupaAdjustment = outputRevenueEntry.getAddOnVisitAmount();
            if (federalLupaAdjustment == null) continue;
            BigDecimal revenueAddOn = calculationContext.calculateAdjustedCost(federalLupaAdjustment);
            outputRevenueEntry.setAddOnVisitAmount(revenueAddOn);
        }
    }
}

