/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.hha.core.rules.final_calculation;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.hha.api.v2.HhaClaimData;
import gov.cms.fiss.pricers.hha.api.v2.HhaClaimPricingRequest;
import gov.cms.fiss.pricers.hha.api.v2.HhaClaimPricingResponse;
import gov.cms.fiss.pricers.hha.api.v2.HhaPaymentData;
import gov.cms.fiss.pricers.hha.api.v2.RevenueLineData;
import gov.cms.fiss.pricers.hha.api.v2.RevenuePaymentData;
import gov.cms.fiss.pricers.hha.core.HhaPricerContext;
import gov.cms.fiss.pricers.hha.core.codes.ReturnCode;
import gov.cms.fiss.pricers.hha.core.models.RevenueRateEntry;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

public class CalculatePartialEpisodePayment
implements CalculationRule<HhaClaimPricingRequest, HhaClaimPricingResponse, HhaPricerContext> {
    @Override
    public void calculate(HhaPricerContext calculationContext) {
        if (calculationContext.getPaymentData().getTotalQuantityOfCoveredVisits() >= calculationContext.getHrgThreshold()) {
            calculationContext.setPartialEpisodePaymentCalculated();
            HhaClaimData claimData = calculationContext.getClaimData();
            Boolean partialEpisodePaymentIndicator = calculationContext.isPartialEpisodePaymentIndicator();
            if (claimData.getHhrgNumberOfDays() > 30) {
                calculationContext.applyReturnCode(ReturnCode.NUMBER_OF_DAYS_EXCEEDS_LIMIT_16);
                return;
            }
            BigDecimal payment = calculationContext.calculatePaymentBasis();
            if (Boolean.TRUE.equals(partialEpisodePaymentIndicator)) {
                BigDecimal percentOfDays = BigDecimal.valueOf((double)claimData.getHhrgNumberOfDays().intValue() / 30.0).setScale(2, RoundingMode.HALF_UP);
                payment = payment.multiply(percentOfDays).setScale(2, RoundingMode.HALF_UP);
                calculationContext.setReturnCodeAdjustmentIndicator(2);
            }
            payment = payment.setScale(2, RoundingMode.HALF_UP);
            calculationContext.setPretotalPepPayment(calculationContext.getPretotalPepPayment().add(payment));
            calculationContext.getPaymentData().setHhrgPayment(payment);
            this.calculateOutlierPayment(calculationContext);
        }
    }

    private void calculateOutlierPayment(HhaPricerContext calculationContext) {
        HhaPaymentData paymentData = calculationContext.getPaymentData();
        BigDecimal outlierThresholdAmountAdjustment = calculationContext.calculateAdjustedCost(calculationContext.getOutlierThresholdAmount());
        BigDecimal totalPayment = calculationContext.getPretotalPepPayment();
        BigDecimal outlierValueA = totalPayment.add(outlierThresholdAmountAdjustment);
        BigDecimal outlierValueB = this.calculateOutlierValueB(calculationContext);
        BigDecimal outlierDifference = outlierValueB.subtract(outlierValueA);
        if (BigDecimalUtils.isGreaterThanZero(outlierDifference)) {
            BigDecimal outlierPayment = calculationContext.getOutlierLossSharingRatio().multiply(outlierDifference).setScale(2, RoundingMode.HALF_UP);
            paymentData.setOutlierPayment(outlierPayment);
            this.calculateOutlierCap(calculationContext);
            totalPayment = totalPayment.add(paymentData.getOutlierPayment());
            switch (calculationContext.getReturnCodeAdjustmentIndicator()) {
                case 2: {
                    calculationContext.applyReturnCode(ReturnCode.PAYMENT_PARTIAL_PERIOD_OUTLIER_11);
                    break;
                }
                case 4: {
                    calculationContext.applyReturnCode(ReturnCode.PAYMENT_WITH_OUTLIER_LIMITATION_2);
                    break;
                }
                default: {
                    calculationContext.applyReturnCode(ReturnCode.PAYMENT_WITH_OUTLIER_1);
                    break;
                }
            }
        } else if (calculationContext.getReturnCodeAdjustmentIndicator() == 2) {
            calculationContext.applyReturnCode(ReturnCode.PAYMENT_PARTIAL_PERIOD_9);
        } else {
            calculationContext.applyReturnCode(ReturnCode.PAYMENT_WITHOUT_OUTLIER_0);
        }
        totalPayment = totalPayment.setScale(2, RoundingMode.HALF_UP);
        paymentData.setTotalPayment(totalPayment);
    }

    private BigDecimal calculateOutlierValueB(HhaPricerContext calculationContext) {
        RevenueRateEntry revenueRateEntry;
        BigDecimal outlierValueB = BigDecimalUtils.ZERO;
        List<RevenueLineData> inputRevenueData = calculationContext.getRevenueLines();
        List<RevenuePaymentData> outputRevenueData = calculationContext.getRevenuePayments();
        List<RevenueRateEntry> revenueRateData = calculationContext.getRevenueData();
        for (int i2 = 0; i2 < revenueRateData.size() && !(revenueRateEntry = revenueRateData.get(i2)).getRevenueCode().isBlank(); ++i2) {
            BigDecimal revenueDollarRateUnits = revenueRateEntry.getDollarRateUnits().multiply(calculationContext.getRuralAddon()).setScale(2, RoundingMode.HALF_UP);
            BigDecimal federalAdjustment = revenueDollarRateUnits.multiply(BigDecimal.valueOf(inputRevenueData.get(i2).getQuantityOfOutlierUnits())).setScale(2, RoundingMode.HALF_UP);
            BigDecimal payment = calculationContext.calculateAdjustedCost(federalAdjustment);
            outputRevenueData.get(i2).setCost(payment.setScale(2, RoundingMode.HALF_UP));
            outlierValueB = outlierValueB.add(payment);
        }
        return outlierValueB;
    }

    private void calculateOutlierCap(HhaPricerContext calculationContext) {
        HhaClaimData claimData = calculationContext.getClaimData();
        HhaPaymentData paymentData = calculationContext.getPaymentData();
        BigDecimal paymentTotal = claimData.getPriorPaymentTotal();
        BigDecimal outlierPaymentTotal = claimData.getPriorOutlierTotal();
        if (BigDecimalUtils.isZero(paymentTotal) || BigDecimalUtils.isZero(outlierPaymentTotal)) {
            return;
        }
        BigDecimal outlierPoolPercent = paymentTotal.multiply(BigDecimal.valueOf(0.1)).setScale(2, RoundingMode.HALF_UP);
        BigDecimal outlierAvailablePool = outlierPoolPercent.subtract(outlierPaymentTotal);
        BigDecimal outlierPoolDiff = outlierAvailablePool.subtract(paymentData.getOutlierPayment());
        if (BigDecimalUtils.isGreaterThanZero(outlierPoolDiff)) {
            return;
        }
        if (BigDecimalUtils.isLessThanZero(outlierPoolDiff) || BigDecimalUtils.isLessThanZero(outlierPaymentTotal)) {
            paymentData.setOutlierPayment(BigDecimalUtils.ZERO);
            calculationContext.setReturnCodeAdjustmentIndicator(4);
        }
    }
}

