/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.hha.core.rules.validate_input;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.hha.api.v2.HhaClaimPricingRequest;
import gov.cms.fiss.pricers.hha.api.v2.HhaClaimPricingResponse;
import gov.cms.fiss.pricers.hha.api.v2.RevenueLineData;
import gov.cms.fiss.pricers.hha.core.HhaPricerContext;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;

public class CalculateTotalQuantityOfCoveredVisits
implements CalculationRule<HhaClaimPricingRequest, HhaClaimPricingResponse, HhaPricerContext> {
    @Override
    public void calculate(HhaPricerContext calculationContext) {
        List<RevenueLineData> inputRevenueData = calculationContext.getRevenueLines();
        int totalCoveredVisits = 0;
        for (RevenueLineData inputRevenueEntry : inputRevenueData) {
            totalCoveredVisits += ObjectUtils.defaultIfNull(inputRevenueEntry.getQuantityOfCoveredVisits(), 0).intValue();
        }
        calculationContext.getPaymentData().setTotalQuantityOfCoveredVisits(totalCoveredVisits);
    }
}

